/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.customizer.preferences;

import com.silabs.customizer.FileUtils;
import com.silabs.customizer.log.MessageLog;
import java.io.File;
import java.io.IOException;
import org.eclipse.jface.preference.IPersistentPreferenceStore;
import org.eclipse.jface.preference.PreferenceStore;

public final class PreferenceConstants {
    public static final String PREF_SHOW_DEFAULTS = "PREF_SHOW_DEFAULTS";
    public static final String PREF_CONFIRM_OTP = "PREF_CONFIRM_OTP";
    public static final String PREF_RETAIN_DEVICE_CONFIG = "PREF_RETAIN_DEVICE_CONFIG";
    public static final String PREF_SERIAL_AUTOINCREMENT = "PREF_SERIAL_AUTOINCREMENT";
    public static final String PREF_SERIAL_PREFIX = "PREF_SERIAL_PREFIX";
    public static final String PREF_SERIAL_SEED = "PREF_SERIAL_SEED";
    public static final String PREF_SERIAL_SEED_FORMAT = "PREF_SERIAL_SEED_FORMAT";
    public static final String PREF_SERIAL_SEED_LENGTH = "PREF_SERIAL_SEED_LENGTH";
    public static final String PREF_SERIAL_POSTFIX = "PREF_SERIAL_POSTFIX";
    public static final String PREF_LOG_TO_FILE = "PREF_LOG_TO_FILE";
    public static final String PREF_LOG_FILE = "PREF_LOG_FILE";
    private static IPersistentPreferenceStore STORE = null;

    public static synchronized IPersistentPreferenceStore getStore() {
        if (STORE == null) {
            STORE = PreferenceConstants.initialize();
        }
        return STORE;
    }

    public static synchronized String getSerial() {
        String result = null;
        if (PreferenceConstants.isAutoIncrementSerial()) {
            IPersistentPreferenceStore store = PreferenceConstants.getStore();
            String prefix = store.getString(PREF_SERIAL_PREFIX).trim();
            String seed = store.getString(PREF_SERIAL_SEED).trim();
            int seedLength = store.getInt(PREF_SERIAL_SEED_LENGTH);
            String postfix = store.getString(PREF_SERIAL_POSTFIX).trim();
            try {
                int diff = seedLength - seed.length();
                if (diff > 0) {
                    seed = "0" + seed;
                    --diff;
                }
                result = String.valueOf(prefix) + seed + postfix;
            }
            catch (NumberFormatException nfe) {
                MessageLog.error("Could not compute serial number", nfe);
            }
        }
        return result;
    }

    public static synchronized boolean incrementSerial() {
        IPersistentPreferenceStore store = PreferenceConstants.getStore();
        boolean change = PreferenceConstants.isAutoIncrementSerial();
        if (change) {
            String seed = store.getString(PREF_SERIAL_SEED).trim();
            int maxLength = store.getInt(PREF_SERIAL_SEED_LENGTH);
            boolean isHex = store.getInt(PREF_SERIAL_SEED_FORMAT) > 0;
            int value = Integer.parseInt(seed, isHex ? 16 : 10);
            seed = String.format(isHex ? "%X" : "%d", ++value);
            int seedLength = seed.length();
            while (seedLength > maxLength && seedLength > 0) {
                seed = seed.substring(1, seedLength);
                --seedLength;
            }
            while (seedLength < maxLength) {
                seed = "0" + seed;
                ++seedLength;
            }
            store.setValue(PREF_SERIAL_SEED, seed);
            try {
                store.save();
            }
            catch (IOException ioe) {
                MessageLog.error("Could not save preferences", ioe);
            }
        }
        return change;
    }

    public static synchronized boolean isAutoIncrementSerial() {
        IPersistentPreferenceStore store = PreferenceConstants.getStore();
        return store.getBoolean(PREF_RETAIN_DEVICE_CONFIG) && store.getBoolean(PREF_SERIAL_AUTOINCREMENT);
    }

    private static File getFile() {
        File result = null;
        try {
            File dir = FileUtils.getConfigLocation();
            if (dir.exists()) {
                String fileName = "com.silabs.customizer.prefs";
                result = new File(dir, fileName);
            }
        }
        catch (Exception exc) {
            MessageLog.error("Failed to load preferences.", exc);
        }
        return result;
    }

    private static IPersistentPreferenceStore initialize() {
        IPersistentPreferenceStore result = PreferenceConstants.createStore();
        result.setDefault(PREF_CONFIRM_OTP, true);
        result.setDefault(PREF_SHOW_DEFAULTS, true);
        result.setDefault(PREF_RETAIN_DEVICE_CONFIG, false);
        result.setDefault(PREF_SERIAL_AUTOINCREMENT, false);
        result.setDefault(PREF_SERIAL_PREFIX, "");
        result.setDefault(PREF_SERIAL_SEED, "1");
        result.setDefault(PREF_SERIAL_SEED_FORMAT, 0);
        result.setDefault(PREF_SERIAL_SEED_LENGTH, 8);
        result.setDefault(PREF_SERIAL_POSTFIX, "");
        result.setDefault(PREF_LOG_TO_FILE, false);
        result.setDefault(PREF_LOG_FILE, "");
        return result;
    }

    private static IPersistentPreferenceStore createStore() {
        PreferenceStore result;
        File file = PreferenceConstants.getFile();
        if (file != null) {
            result = new PreferenceStore(file.getAbsolutePath());
            if (file.exists()) {
                MessageLog log = new MessageLog();
                try {
                    log.logDebug("Loading preferences from:", file.getAbsoluteFile());
                    result.load();
                }
                catch (IOException exc) {
                    log.logError("Could not load preferences. Using defaults.", exc);
                }
                log.dispose();
            }
        } else {
            result = new PreferenceStore();
        }
        return result;
    }
}

