/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.customizer.log;

import com.silabs.customizer.UIConstants;
import com.silabs.customizer.log.AbstractAppender;
import com.silabs.customizer.log.MessageLog;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.util.Date;
import org.osgi.service.log.LogEntry;

public final class FileAppender
extends AbstractAppender {
    private File file;
    private PrintWriter writer;

    public File isValid(String path) {
        return this.isValid(new File(path.trim()));
    }

    @Override
    public synchronized void logged(LogEntry entry) {
        if (this.writer != null) {
            this.writer.println(this.getMessage(entry));
            if (entry.getException() != null) {
                entry.getException().printStackTrace(this.writer);
            }
            this.writer.flush();
        }
    }

    public synchronized void setFile(File file) {
        File candidate = this.isValid(file);
        if (candidate != null && !candidate.equals(this.file)) {
            this.stop();
            this.file = candidate;
        }
    }

    @Override
    public synchronized void start() {
        if (this.writer == null && this.file != null) {
            try {
                this.writer = new PrintWriter(new FileWriter(this.file, true));
                super.start();
            }
            catch (IOException ioe) {
                MessageLog.error("Could not open log: " + this.file.getAbsolutePath(), ioe);
            }
        }
    }

    @Override
    public synchronized void stop() {
        if (this.writer != null) {
            super.stop();
            this.writer.close();
            this.writer = null;
        }
    }

    private String getMessage(LogEntry entry) {
        Date date = new Date(entry.getTime());
        String dateStr = DateFormat.getInstance().format(date);
        String message = entry.getMessage();
        return String.format("%s: %s\n", dateStr, message);
    }

    private File isValid(File file) {
        File result;
        try {
            result = file.getCanonicalFile();
            if (file.exists()) {
                if (!result.canWrite()) {
                    result = null;
                } else if (UIConstants.isWsWindows()) {
                    new FileWriter(file, true).close();
                }
            } else if (file.createNewFile()) {
                file.delete();
            } else {
                result = null;
            }
        }
        catch (IOException iOException) {
            result = null;
        }
        return result;
    }
}

