/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.customizer.log;

import com.silabs.customizer.log.MessageLog;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.service.log.LogEntry;
import org.osgi.service.log.LogListener;
import org.osgi.service.log.LogReaderService;
import org.osgi.util.tracker.ServiceTracker;

abstract class AbstractAppender
implements LogListener,
ServiceListener {
    private final List<LogReaderService> readers = new LinkedList<LogReaderService>();
    private ServiceTracker<LogReaderService, Object> lrsTracker;

    public abstract void logged(LogEntry var1);

    public final void serviceChanged(ServiceEvent event) {
        LogReaderService readerService = (LogReaderService)this.getContext().getService(event.getServiceReference());
        if (readerService != null) {
            switch (event.getType()) {
                case 1: {
                    readerService.addLogListener((LogListener)this);
                    this.readers.add(readerService);
                    break;
                }
                case 4: {
                    readerService.removeLogListener((LogListener)this);
                    this.readers.remove(readerService);
                }
            }
        }
    }

    protected void start() {
        String serviceName = LogReaderService.class.getName();
        this.lrsTracker = new ServiceTracker(this.getContext(), serviceName, null);
        this.lrsTracker.open();
        Object[] readers = this.lrsTracker.getServices();
        if (readers != null) {
            Object[] objectArray = readers;
            int n = readers.length;
            int n2 = 0;
            while (n2 < n) {
                Object reader = objectArray[n2];
                LogReaderService readerService = (LogReaderService)reader;
                readerService.addLogListener((LogListener)this);
                ++n2;
            }
        }
        try {
            String filter = "(objectclass=" + serviceName + ")";
            this.getContext().addServiceListener((ServiceListener)this, filter);
        }
        catch (InvalidSyntaxException exc) {
            MessageLog.error("Should not happen!", (Exception)((Object)exc));
        }
    }

    protected void stop() {
        this.lrsTracker.close();
        this.getContext().removeServiceListener((ServiceListener)this);
        for (LogReaderService readerService : this.readers) {
            readerService.removeLogListener((LogListener)this);
        }
        this.readers.clear();
    }

    private BundleContext getContext() {
        Bundle bundle = Platform.getBundle((String)"com.silabs.customizer");
        return bundle.getBundleContext();
    }
}

