/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.customizer.dialogs;

import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

public class FlushBuffersDialog
extends StatusDialog {
    private int numFlushInterfaces;
    private Button[] bits;
    private Label lblDescr;
    private String description;
    private Label lblResult;
    private String value;

    public FlushBuffersDialog(Shell parent, int numFlushInterfaces) {
        super(parent);
        this.numFlushInterfaces = numFlushInterfaces;
        this.bits = new Button[this.numFlushInterfaces * 4];
        this.setShellStyle(this.getShellStyle() | 0x10000000);
        this.setTitle("Flush Buffers Settings");
        this.setDescription("Bitmask specifying whether the RX and/or TX FIFOs are purged upon a device open and/or close.");
        this.setValue("0000");
    }

    public String getValue() {
        return this.value;
    }

    public final void setDescription(String description) {
        this.description = description;
        if (this.lblDescr != null) {
            this.lblDescr.setText(description);
        }
    }

    public final void setValue(String hexWord) {
        if (hexWord.length() > 4) {
            throw new NumberFormatException("hexWord: " + String.valueOf(hexWord));
        }
        if (this.bits[0] == null) {
            this.value = String.format("%04X", Integer.parseInt(hexWord, 16));
        } else {
            Integer hexValue = Integer.parseInt(hexWord, 16);
            int i = 0;
            while (i < this.numFlushInterfaces) {
                this.bits[i * 4 + 0].setSelection((hexValue & 1 << i * 4) != 0);
                this.bits[i * 4 + 1].setSelection((hexValue & 2 << i * 4) != 0);
                this.bits[i * 4 + 2].setSelection((hexValue & 4 << i * 4) != 0);
                this.bits[i * 4 + 3].setSelection((hexValue & 8 << i * 4) != 0);
                ++i;
            }
            this.value = this.computeValue();
        }
    }

    protected Control createDialogArea(Composite parent) {
        FontData[] fontDatas;
        Composite result = (Composite)super.createDialogArea(parent);
        GridLayout layout = (GridLayout)result.getLayout();
        layout.numColumns = 1;
        layout.makeColumnsEqualWidth = true;
        GridDataFactory gdfFill2 = GridDataFactory.fillDefaults().grab(true, false);
        this.lblDescr = new Label(result, 64);
        this.lblDescr.setText(String.valueOf(this.description));
        gdfFill2.copy().minSize(250, -1).applyTo((Control)this.lblDescr);
        this.createSpacer(result);
        int i = 0;
        while (i < this.numFlushInterfaces) {
            this.bits[i * 4 + 0] = this.createButton(result, String.format("Flush IFC %d TX on Open", i));
            this.bits[i * 4 + 1] = this.createButton(result, String.format("Flush IFC %d RX on Open", i));
            this.bits[i * 4 + 2] = this.createButton(result, String.format("Flush IFC %d TX on Close", i));
            this.bits[i * 4 + 3] = this.createButton(result, String.format("Flush IFC %d RX on Close", i));
            ++i;
        }
        this.createSpacer(result);
        this.lblResult = new Label(result, 0);
        this.setValue(this.value);
        this.lblResult.setText("Result (hex): " + this.value);
        gdfFill2.applyTo((Control)this.lblResult);
        FontData[] fontDataArray = fontDatas = this.lblResult.getFont().getFontData();
        int n = fontDatas.length;
        int n2 = 0;
        while (n2 < n) {
            FontData fd = fontDataArray[n2];
            fd.setStyle(1);
            ++n2;
        }
        final Font fontBold = new Font((Device)this.lblResult.getDisplay(), fontDatas);
        this.lblResult.setFont(fontBold);
        this.lblResult.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                fontBold.dispose();
            }
        });
        this.addListeners();
        return result;
    }

    private void addListeners() {
        SelectionAdapter selectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FlushBuffersDialog.this.value = FlushBuffersDialog.this.computeValue();
                FlushBuffersDialog.this.lblResult.setText("Result (hex): " + FlushBuffersDialog.this.value);
            }
        };
        Button[] buttonArray = this.bits;
        int n = this.bits.length;
        int n2 = 0;
        while (n2 < n) {
            Button button = buttonArray[n2];
            button.addSelectionListener((SelectionListener)selectionListener);
            ++n2;
        }
    }

    private String computeValue() {
        long value = 0L;
        if (this.bits.length == 4) {
            value = 240L;
        }
        int i = 0;
        while (i < this.bits.length) {
            value |= (long)((this.bits[i].getSelection() ? 1 : 0) << i);
            ++i;
        }
        String result = String.format("%04X", value);
        return result;
    }

    private Button createButton(Composite parent, String caption) {
        Button result = new Button(parent, 32);
        result.setText(caption);
        return result;
    }

    private void createSpacer(Composite result) {
        Label lblSpacer = new Label(result, 0);
        GridDataFactory.fillDefaults().grab(true, false).span(2, 1).applyTo((Control)lblSpacer);
    }
}

