/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.customizer.devices.cp261x.XMLtoHEX;

import com.silabs.customizer.devices.cp261x.XMLtoHEX.Parameter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import org.jdom2.Attribute;
import org.jdom2.Element;

public class ParameterGroup {
    Element rootNode;

    public ParameterGroup(Element parmNode) {
        this.rootNode = parmNode;
    }

    public int length() {
        int ret = 4;
        for (Element child : this.rootNode.getChildren()) {
            if (!child.getName().equals("parameter")) continue;
            Parameter parm = new Parameter(child);
            ret += parm.length();
        }
        return ret;
    }

    public void renderForC(PrintStream outStream) {
        Attribute nameAttr = this.rootNode.getAttribute("name");
        if (nameAttr == null) {
            outStream.println("Missing name attribute for parm group");
            return;
        }
        Attribute idAttr = this.rootNode.getAttribute("id");
        if (idAttr == null) {
            outStream.println("Missing id attribute for parm group");
            return;
        }
        int length = this.length();
        int id = Integer.parseInt(idAttr.getValue());
        outStream.printf("  //~~~~~~~~~~~~~~\n", new Object[0]);
        outStream.printf("  // parameter group name: %s / id %s / length %d\n", nameAttr.getValue(), idAttr.getValue(), length);
        for (Element child : this.rootNode.getChildren()) {
            if (!child.getName().equals("comment")) continue;
            outStream.printf("  // %s\n", child.getText());
        }
        outStream.printf("  0x%02X, 0x%02X, // parm group length\n", length >> 8 & 0xFF, length & 0xFF);
        outStream.printf("  0x%02X, 0x%02X, // parm group id\n", id >> 8 & 0xFF, id & 0xFF);
        outStream.printf("\n", new Object[0]);
        for (Element child : this.rootNode.getChildren()) {
            if (!child.getName().equals("parameter")) continue;
            Parameter parm = new Parameter(child);
            parm.renderForC(outStream);
        }
    }

    public void renderForBin(OutputStream outStream) {
        Attribute nameAttr = this.rootNode.getAttribute("name");
        if (nameAttr == null) {
            return;
        }
        Attribute idAttr = this.rootNode.getAttribute("id");
        if (idAttr == null) {
            return;
        }
        int length = this.length();
        int id = Integer.parseInt(idAttr.getValue());
        try {
            outStream.write(length >> 8 & 0xFF);
            outStream.write(length & 0xFF);
            outStream.write(id >> 8 & 0xFF);
            outStream.write(id & 0xFF);
        }
        catch (IOException iOException) {
            System.out.println("Error writing to binary output stream in ParameterGroup::renderForBin()");
            System.exit(1);
        }
        for (Element child : this.rootNode.getChildren()) {
            if (!child.getName().equals("parameter")) continue;
            Parameter parm = new Parameter(child);
            parm.renderForBin(outStream);
        }
    }
}

