/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.customizer.devices.cp261x.XMLtoHEX;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.Element;

public class Field {
    Element node;

    public Field(Element fieldNode) {
        this.node = fieldNode;
    }

    public Field(String name, int size, String type, boolean useOrder, ByteOrder order, String value) {
        if (name == null) {
            throw new IllegalArgumentException("argument name cannot be null");
        }
        if (value == null) {
            throw new IllegalArgumentException("argument value cannot be null");
        }
        this.node = new Element("field");
        this.node.setAttribute("name", name);
        if (size != 0) {
            this.node.setAttribute("size", "" + size);
        }
        if (type != null) {
            this.node.setAttribute("type", type);
        }
        if (useOrder) {
            if (order == ByteOrder.BIG_ENDIAN) {
                this.node.setAttribute("order", "be");
            } else {
                this.node.setAttribute("order", "le");
            }
        }
        Element valueNode = new Element("value");
        valueNode.setText(value);
        this.node.addContent((Content)valueNode);
    }

    public void addComment(String comment) {
        if (comment != null) {
            Element commentNode = new Element("comment");
            commentNode.setText(comment);
            this.node.addContent((Content)commentNode);
        }
    }

    public Element getElement() {
        return this.node;
    }

    static String getOrderedByteString(int num, int count, ByteOrder order) {
        ByteBuffer bbuf = ByteBuffer.allocate(count == 3 ? 4 : count);
        bbuf.order(order);
        switch (count) {
            case 1: {
                bbuf.put((byte)num);
                break;
            }
            case 2: {
                bbuf.putShort((short)num);
                break;
            }
            case 3: 
            case 4: {
                bbuf.putInt(num);
                break;
            }
            default: {
                return "unexpected count for byte string\n";
            }
        }
        byte[] orderedBytes = bbuf.array();
        String orderedString = new String();
        int idx = 0;
        if (count == 3 && order == ByteOrder.BIG_ENDIAN) {
            idx = 1;
            count = 4;
        }
        while (idx < count) {
            orderedString = orderedString.concat(String.format("0x%02X, ", orderedBytes[idx]));
            ++idx;
        }
        return orderedString;
    }

    private static void renderNumStringAsBin(String numString, OutputStream binStream) {
        String[] splitString = numString.split(",");
        try {
            int i = 0;
            while (i < splitString.length) {
                if (!splitString[i].trim().equals("")) {
                    int num = Integer.decode(splitString[i].trim());
                    binStream.write(num);
                    ++i;
                    continue;
                }
                break;
            }
        }
        catch (IOException iOException) {
            System.out.println("Error writing to binary output stream in Field::renderNumStringAsBin()");
            System.exit(1);
        }
    }

    private void render(PrintStream txtStream, OutputStream binStream) throws IOException {
        block27: {
            Attribute nameAttr = this.node.getAttribute("name");
            if (nameAttr == null) {
                txtStream.println("Missing name attribute for <field>");
                return;
            }
            Element valueNode = this.node.getChild("value");
            if (valueNode == null) {
                txtStream.println("Missing value element for <field name = \"" + this.node.getName() + "\">");
                return;
            }
            Attribute sizeAttr = this.node.getAttribute("size");
            int size = 0;
            size = sizeAttr == null ? this.length() : Integer.parseInt(sizeAttr.getValue());
            Attribute typeAttr = this.node.getAttribute("type");
            Attribute orderAttr = this.node.getAttribute("order");
            ByteOrder byteOrder = ByteOrder.BIG_ENDIAN;
            if (orderAttr != null && orderAttr.getValue().equals("le")) {
                byteOrder = ByteOrder.LITTLE_ENDIAN;
            }
            txtStream.printf("  // field name: %s / size: %d\n", nameAttr.getValue(), size);
            txtStream.printf("  // value: %s\n", valueNode.getValue());
            Element commentNode = this.node.getChild("comment");
            if (commentNode != null) {
                txtStream.printf("  // %s\n", commentNode.getValue());
            }
            if (typeAttr == null) {
                txtStream.printf("  %s,\n", valueNode.getValue());
                Field.renderNumStringAsBin(valueNode.getValue(), binStream);
            } else if (typeAttr.getValue().equals("blob")) {
                txtStream.printf("  %s,\n", valueNode.getValue());
                Field.renderNumStringAsBin(valueNode.getValue(), binStream);
            } else if (typeAttr.getValue().equals("hex")) {
                String hexString = valueNode.getValue();
                hexString = hexString.startsWith("0x") ? hexString.substring(2) : hexString;
                int hexNum = Integer.parseInt(hexString, 16);
                String hexStr = Field.getOrderedByteString(hexNum, size, byteOrder);
                txtStream.printf("  %s\n", hexStr);
                Field.renderNumStringAsBin(hexStr, binStream);
            } else if (typeAttr.getValue().equals("dec")) {
                String decString = valueNode.getValue();
                int decNum = Integer.parseInt(decString, 10);
                String decStr = Field.getOrderedByteString(decNum, size, byteOrder);
                txtStream.printf("  %s\n", decStr);
                Field.renderNumStringAsBin(decStr, binStream);
            } else if (typeAttr.getValue().equals("num")) {
                String numString = valueNode.getValue();
                int num = Integer.decode(numString);
                String numStr = Field.getOrderedByteString(num, size, byteOrder);
                txtStream.printf("  %s\n", numStr);
                Field.renderNumStringAsBin(numStr, binStream);
            } else if (typeAttr.getValue().equals("utf8") || typeAttr.getValue().equals("utf8usb")) {
                try {
                    byte[] utf8Bytes = valueNode.getValue().getBytes("UTF-8");
                    int bytesLen = utf8Bytes.length;
                    ++bytesLen;
                    if (typeAttr.getValue().equals("utf8usb")) {
                        bytesLen += 3;
                    }
                    if (bytesLen != size) {
                        txtStream.println("String length mismatch in field");
                        break block27;
                    }
                    if (typeAttr.getValue().equals("utf8usb")) {
                        txtStream.printf("  1, %d, 3, // USB string header\n", utf8Bytes.length * 2 + 2);
                        binStream.write(1);
                        binStream.write(utf8Bytes.length * 2 + 2);
                        binStream.write(3);
                    }
                    txtStream.printf("  ", new Object[0]);
                    int pos = 0;
                    int i = 0;
                    while (i < utf8Bytes.length) {
                        if (pos == 8) {
                            pos = 0;
                            txtStream.printf("\n  ", new Object[0]);
                        }
                        txtStream.printf("0x%02X, ", utf8Bytes[i]);
                        binStream.write(utf8Bytes[i]);
                        ++pos;
                        ++i;
                    }
                    txtStream.printf("0,\n", new Object[0]);
                    binStream.write(0);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {}
            } else if (typeAttr.getValue().equals("fill") || typeAttr.getValue().equals("computed")) {
                byte valByte = (byte)(Short.decode(valueNode.getValue()) & 0xFF);
                txtStream.printf("  ", new Object[0]);
                int pos = 0;
                int i = 0;
                while (i < size) {
                    if (pos == 8) {
                        pos = 0;
                        txtStream.printf("\n  ", new Object[0]);
                    }
                    txtStream.printf("0x%02X, ", valByte);
                    binStream.write(valByte);
                    ++pos;
                    ++i;
                }
                txtStream.printf("\n", new Object[0]);
            } else {
                txtStream.printf("  %s,\n", valueNode.getValue());
                Field.renderNumStringAsBin(valueNode.getValue(), binStream);
            }
        }
        txtStream.printf("\n", new Object[0]);
    }

    public void renderForBin(OutputStream binStream) {
        ByteArrayOutputStream dummyOutputStream = new ByteArrayOutputStream();
        PrintStream txtStream = new PrintStream(dummyOutputStream);
        try {
            this.render(txtStream, binStream);
        }
        catch (IOException iOException) {
            System.out.println("Error writing to binary output stream in Field::renderForBin()");
            System.exit(1);
        }
    }

    public void renderForC(PrintStream outStream) {
        ByteArrayOutputStream binStream = new ByteArrayOutputStream();
        try {
            this.render(outStream, binStream);
        }
        catch (IOException iOException) {
            System.out.println("Error writing to binary output stream in Field::renderForC()");
            System.exit(1);
        }
    }

    public int length() {
        int ret = 0;
        Attribute sizeAttr = this.node.getAttribute("size");
        if (sizeAttr != null) {
            ret = Integer.parseInt(sizeAttr.getValue());
        } else {
            Element valueNode;
            Attribute typeAttr = this.node.getAttribute("type");
            if (typeAttr != null && (typeAttr.getValue().equals("utf8") || typeAttr.getValue().equals("utf8usb")) && (valueNode = this.node.getChild("value")) != null) {
                try {
                    byte[] utf8Bytes = valueNode.getText().getBytes("UTF-8");
                    ret = utf8Bytes.length;
                    ++ret;
                    if (typeAttr.getValue().equals("utf8usb")) {
                        ret += 3;
                    }
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {}
            }
        }
        return ret;
    }

    public static void main(String[] args) {
        System.out.println("Unit test for Field class");
        Element testField = new Element("field");
        testField.setAttribute("name", "serialDataRate");
        testField.setAttribute("size", "4");
        testField.setAttribute("type", "num");
        Element testValue = new Element("value");
        testValue.setText("115200");
        testField.addContent((Content)testValue);
        Element testComment = new Element("comment");
        testComment.setText("Serial data is set at 115200");
        testField.addContent((Content)testComment);
        Field field = new Field(testField);
        System.out.println("Test element");
        System.out.println("------------");
        System.out.println("name=serialDataRate size=4 type=num");
        System.out.println("------------");
        System.out.println("Rendered output of field");
        System.out.println("========================");
        field.renderForC(System.out);
        System.out.println("========================");
        System.out.println("length()=" + field.length());
        testField.setAttribute("order", "le");
        field = new Field(testField);
        System.out.println("Repeat but with le");
        System.out.println("========================");
        field.renderForC(System.out);
        System.out.println("========================");
        System.out.println("length()=" + field.length());
        field = new Field("usbLanguageCode", 2, "hex", false, null, "0x0409");
        System.out.println("Test element");
        System.out.println("------------");
        System.out.println("name=usbLanguageCode size=2 type=hex");
        System.out.println("------------");
        System.out.println("Rendered output of field");
        System.out.println("========================");
        field.renderForC(System.out);
        System.out.println("========================");
        System.out.println("length()=" + field.length());
        testField = new Element("field");
        testField.setAttribute("name", "mfiDefaultLanguageStr");
        testField.setAttribute("size", "3");
        testField.setAttribute("type", "utf8");
        testValue = new Element("value");
        testValue.setText("en");
        testField.addContent((Content)testValue);
        testComment = new Element("comment");
        testComment.setText("Support language is english");
        testField.addContent((Content)testComment);
        field = new Field(testField);
        System.out.println("Test element");
        System.out.println("------------");
        System.out.println("name=mfiDefaultLanguageStr size=3 type=utf8");
        System.out.println("------------");
        System.out.println("Rendered output of field");
        System.out.println("========================");
        field.renderForC(System.out);
        System.out.println("========================");
        System.out.println("length()=" + field.length());
    }
}

