/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.customizer.devices.cp261x;

import com.silabs.customizer.devices.Device;
import com.silabs.customizer.devices.Item;
import com.silabs.customizer.devices.Property;
import java.util.Locale;

public class PropertySerialDataRate
extends Property {
    public PropertySerialDataRate(Device device) {
        super(device, null, "Serial Data Rate", new Item[]{new Item("0", "9600"), new Item("1", "19200"), new Item("2", "38400"), new Item("3", "57600"), new Item("4", "115200")});
        this.initProperty();
    }

    @Override
    public void setDefaultValue(String value) {
        super.setDefaultValue(value.toUpperCase(Locale.ENGLISH));
    }

    @Override
    public void setValue(String value) {
        try {
            super.setValue(value);
        }
        catch (NumberFormatException numberFormatException) {}
    }

    @Override
    protected String readValueFromDevice() throws Exception {
        return "4";
    }

    @Override
    public String getXMLValue() {
        String baudRateString = "115200";
        if (this.getValue().equals("0")) {
            baudRateString = "9600";
        } else if (this.getValue().equals("1")) {
            baudRateString = "19200";
        } else if (this.getValue().equals("2")) {
            baudRateString = "38400";
        } else if (this.getValue().equals("3")) {
            baudRateString = "57600";
        } else if (this.getValue().equals("4")) {
            baudRateString = "115200";
        }
        String xmlValueString = "  <field name=\"serialDataRate\" size=\"4\" type=\"num\">\n";
        xmlValueString = String.valueOf(xmlValueString) + "    <value>";
        xmlValueString = String.valueOf(xmlValueString) + baudRateString;
        xmlValueString = String.valueOf(xmlValueString) + "</value>\n";
        xmlValueString = String.valueOf(xmlValueString) + "  </field>";
        return xmlValueString;
    }
}

