/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.customizer.devices.cp261x;

import com.silabs.customizer.devices.Device;
import com.silabs.customizer.devices.Property;
import java.util.Locale;

public class PropertyCLKOUTFrequency
extends Property {
    public PropertyCLKOUTFrequency(Device device) {
        super(device, null, "CLKOUT Frequency (Hz)", null);
        this.initProperty();
    }

    @Override
    public void setDefaultValue(String value) {
        super.setDefaultValue(value.toUpperCase(Locale.ENGLISH));
    }

    @Override
    public void setValue(String value) {
        try {
            Long longValue = Long.parseLong(value);
            super.setValue(String.format("%d", longValue));
        }
        catch (NumberFormatException numberFormatException) {}
    }

    @Override
    protected String readValueFromDevice() throws Exception {
        return "24";
    }

    @Override
    public String getXMLValue() {
        long clkoutDivider = 48L / (Long.parseLong(this.getValue()) * 2L);
        String xmlValueString = "  <field name=\"clkoutDivider\" size=\"1\" type=\"num\">\n";
        xmlValueString = String.valueOf(xmlValueString) + "    <comment>CLKOUT = 48 / (";
        xmlValueString = String.valueOf(xmlValueString) + String.format("%d", clkoutDivider);
        xmlValueString = String.valueOf(xmlValueString) + " * 2) ==> ";
        xmlValueString = String.valueOf(xmlValueString) + this.getValue();
        xmlValueString = String.valueOf(xmlValueString) + "MHz (if enabled)</comment>\n";
        xmlValueString = String.valueOf(xmlValueString) + "    <value>";
        xmlValueString = String.valueOf(xmlValueString) + String.format("%d", clkoutDivider);
        xmlValueString = String.valueOf(xmlValueString) + "</value>\n";
        xmlValueString = String.valueOf(xmlValueString) + "  </field>";
        return xmlValueString;
    }
}

