/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.customizer.devices.cp261x;

import com.silabs.customizer.devices.Device;
import com.silabs.customizer.devices.DeviceDetector;
import com.silabs.customizer.devices.Property;
import com.silabs.customizer.devices.cp210x.CP210xBaudConfig;
import com.silabs.customizer.devices.cp213x.SLAB_USB_SPI;
import com.silabs.customizer.devices.cp261x.CP2614ConfigLibrary;
import com.silabs.customizer.devices.cp261x.Device2614;
import com.silabs.customizer.log.MessageLog;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.IntByReference;
import java.util.LinkedList;
import java.util.List;

public abstract class Device261x
extends Device {
    public static final MessageLog LOG = new MessageLog();
    private String serial;
    private String name;

    static {
        LOG.logDebug("CP261x Library Version    :", Device261x.getLibraryVersion());
    }

    public static synchronized List<Device> getDevices() {
        Device261x.checkDeviceDetection();
        LinkedList<Device> result = new LinkedList<Device>();
        int numDevices = Device261x.getNumDevices();
        int i = 0;
        while (i < numDevices) {
            try {
                String serial = Device261x.getSerial(i);
                Device261x.getPartNumber(i);
                result.add(new Device2614(serial));
            }
            catch (Exception exception) {}
            ++i;
        }
        return result;
    }

    @Override
    protected Property[] createPortConfigs() {
        Property[] result = new Property[]{};
        return result;
    }

    @Override
    protected Property[] createBaudConfigs() {
        Property[] result = new Property[]{};
        return result;
    }

    @Override
    public final synchronized String getTransferPriority(Device deviceObj) throws Exception {
        return "XX";
    }

    @Override
    public final synchronized String getManufacturer(Device deviceObj) throws Exception {
        return "XX";
    }

    @Override
    public final synchronized String getPID(Device deviceObj) throws Exception {
        return "XXXX";
    }

    @Override
    public final synchronized String getPower(Device deviceObj) throws Exception {
        return "XX";
    }

    @Override
    public final synchronized String getPowerMode(Device deviceObj) throws Exception {
        return "XX";
    }

    @Override
    public final synchronized String getProduct(Device deviceObj) throws Exception {
        return "XX";
    }

    @Override
    public final synchronized String getReleaseVersion(Device deviceObj) throws Exception {
        return "XX";
    }

    @Override
    public final synchronized String getSerial(Device deviceObj) throws Exception {
        return "00001234";
    }

    @Override
    public final synchronized String getVID(Device deviceObj) throws Exception {
        return "XXXX";
    }

    @Override
    public final synchronized void setManufacturer(Device deviceObj, String manufacturer) throws Exception {
    }

    @Override
    public final synchronized void setProduct(Device deviceObj, String product) throws Exception {
    }

    @Override
    public final synchronized void setSerial(Device deviceObj, String serial) throws Exception {
    }

    @Override
    public final synchronized void setTransferPriority(Device deviceObj, String value) throws Exception {
    }

    @Override
    public final synchronized void setReleaseVersion(Device deviceObj, String value) throws Exception {
    }

    @Override
    public final synchronized void setPID(Device deviceObj, String value) throws Exception {
    }

    @Override
    public final synchronized void setVID(Device deviceObj, String value) throws Exception {
    }

    @Override
    public final synchronized void setPower(Device deviceObj, String value) throws Exception {
    }

    @Override
    public final synchronized void setPowerMode(Device deviceObj, String value) throws Exception {
    }

    protected static synchronized void checkDeviceDetection() {
        if (!DeviceDetector.getDefault().isStopped()) {
            new IllegalStateException("Device detection still active");
        }
    }

    protected static synchronized void close(Pointer device) {
        if (device != null) {
            SLAB_USB_SPI.DLL.CP213x_Close(device);
        }
    }

    private static synchronized Object getLibraryVersion() {
        String result = "";
        IntByReference major = new IntByReference();
        IntByReference minor = new IntByReference();
        IntByReference release = new IntByReference();
        int status = SLAB_USB_SPI.DLL.CP213x_GetLibraryVersion(major, minor, release);
        if (status == 0) {
            String strRelease = release.getValue() > 0 ? "release" : "debug";
            result = String.format("%d.%d-%s", major.getValue(), minor.getValue(), strRelease);
        }
        return result;
    }

    private static synchronized int getNumDevices() {
        IntByReference numDevices = new IntByReference();
        int status = CP2614ConfigLibrary.CP261x_GetNumDevices(numDevices);
        if (status != 0) {
            numDevices.setValue(0);
        }
        return numDevices.getValue();
    }

    private static synchronized PartNumber getPartNumber(int deviceNum) throws Exception {
        return null;
    }

    private static synchronized String getSerial(int deviceNum) throws Exception {
        return "temp-serial";
    }

    @Override
    public String getInterfaceString(Device device, int interfaceNumber) throws Exception {
        return null;
    }

    @Override
    public void setInterfaceString(Device device, int interfaceNumber, String value) throws Exception {
    }

    @Override
    public String getDeviceMode(Device device) throws Exception {
        return null;
    }

    @Override
    public void setDeviceMode(Device device, String value) throws Exception {
    }

    @Override
    public String getDeviceString() {
        return this.getName();
    }

    @Override
    public void setBaudConfig(Device deviceObj, CP210xBaudConfig writeConfig) throws Exception {
    }

    @Override
    public CP210xBaudConfig getBaudConfig(Device deviceObj) throws Exception {
        return null;
    }

    @Override
    public void setFlushBuffers(Device deviceObj, String value) throws Exception {
    }

    @Override
    public String getFlushBuffers(Device deviceObj) throws Exception {
        return null;
    }

    protected static String toHexString(int value, int digits) {
        String result = String.format("%X", value);
        int diff = digits - result.length();
        while (diff > 0) {
            result = "0" + result;
            --diff;
        }
        return result;
    }

    protected Device261x(String serial) {
        this.setSerial(serial);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getSerial() {
        return this.serial;
    }

    @Override
    public void setSerial(String serial) {
        if (serial == null) {
            throw new NullPointerException("serial");
        }
        this.serial = serial;
        this.name = String.valueOf(this.getType()) + " - " + serial;
    }

    @Override
    public String getLockValue(Device device) throws Exception {
        return null;
    }

    @Override
    public void setLockValue(Device device, String value) throws Exception {
    }

    private static final class PartNumber {
        private final int number;
        private final int version;

        public PartNumber(int number, int version) {
            this.number = number;
            this.version = version;
        }
    }
}

