/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.customizer.devices.cp213x;

import java.util.Arrays;

public final class CP2130PinConfig {
    public static final int pinConfigBufferSize = 20;
    public static final int expectedPinCount = 11;
    final int[] pinConfigs;
    final int useSuspendValues;
    final int suspendValue;
    final int suspendMode;
    final int wakeMask;
    final int wakeMatch;
    final short clkDiv;

    CP2130PinConfig(int[] pinConfigs, int useSuspendValues, int suspendValue, int suspendMode, int wakeMask, int wakeMatch, short clkDiv) {
        if (pinConfigs.length != 11) {
            throw new IllegalArgumentException("pinConfig.length != expectedPinCount");
        }
        this.pinConfigs = new int[11];
        System.arraycopy(pinConfigs, 0, this.pinConfigs, 0, this.pinConfigs.length);
        this.useSuspendValues = useSuspendValues;
        this.suspendValue = suspendValue;
        this.suspendMode = suspendMode;
        this.wakeMask = wakeMask;
        this.wakeMatch = wakeMatch;
        this.clkDiv = clkDiv;
    }

    CP2130PinConfig(byte[] pinConfigBuffer) {
        if (pinConfigBuffer.length != 20) {
            throw new IllegalArgumentException("pinConfig.length != pinConfigBufferSize");
        }
        this.pinConfigs = new int[11];
        int i = 0;
        while (i < 11) {
            this.pinConfigs[i] = pinConfigBuffer[i];
            ++i;
        }
        this.suspendValue = pinConfigBuffer[i + 1] & 0xFF | pinConfigBuffer[i] << 8 & 0xFF00;
        this.useSuspendValues = (pinConfigBuffer[i += 2] & 0x80) >> 7;
        this.suspendMode = pinConfigBuffer[i + 1] & 0xFF | pinConfigBuffer[i] << 8 & 0x7F00;
        this.wakeMask = pinConfigBuffer[(i += 2) + 1] & 0xFF | pinConfigBuffer[i] << 8 & 0xFF00;
        this.wakeMatch = pinConfigBuffer[(i += 2) + 1] & 0xFF | pinConfigBuffer[i] << 8 & 0xFF00;
        this.clkDiv = (short)(pinConfigBuffer[i += 2] & 0xFF);
    }

    public String toString() {
        return String.format("PinConfig [pinConfig=%s, useSuspendValues=%04X, suspendValue=%04X, suspendMode=%04X, wakeMask=%04X, wakeMatch=%04X, clkDiv=%02X]", Arrays.toString(this.pinConfigs), this.useSuspendValues, this.suspendValue, this.suspendMode, this.wakeMask, this.wakeMatch, this.clkDiv);
    }

    public byte[] getConfigBuffer() {
        byte[] pinConfigBuffer = new byte[20];
        int i = 0;
        while (i < 11) {
            pinConfigBuffer[i] = (byte)this.pinConfigs[i];
            ++i;
        }
        pinConfigBuffer[i++] = (byte)(this.suspendValue >> 8 & 0xFF);
        pinConfigBuffer[i++] = (byte)this.suspendValue;
        pinConfigBuffer[i] = (byte)(this.useSuspendValues << 7 & 0x80);
        int n = i++;
        pinConfigBuffer[n] = (byte)(pinConfigBuffer[n] | (byte)(this.suspendMode >> 8 & 0x7F));
        pinConfigBuffer[i++] = (byte)this.suspendMode;
        pinConfigBuffer[i++] = (byte)(this.wakeMask >> 8 & 0xFF);
        pinConfigBuffer[i++] = (byte)this.wakeMask;
        pinConfigBuffer[i++] = (byte)(this.wakeMatch >> 8 & 0xFF);
        pinConfigBuffer[i++] = (byte)this.wakeMatch;
        pinConfigBuffer[i++] = (byte)this.clkDiv;
        return pinConfigBuffer;
    }
}

