/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.customizer.devices.cp211x;

import com.silabs.customizer.devices.Device;
import com.silabs.customizer.devices.DeviceDetector;
import com.silabs.customizer.devices.Property;
import com.silabs.customizer.devices.cp210x.CP210xBaudConfig;
import com.silabs.customizer.devices.cp211x.Device2110;
import com.silabs.customizer.devices.cp211x.Device2114;
import com.silabs.customizer.devices.cp211x.SLABHIDtoUART;
import com.silabs.customizer.log.MessageLog;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.ByteByReference;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.PointerByReference;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;

public abstract class Device211x
extends Device {
    public static final MessageLog LOG = new MessageLog();
    private String serial;
    private String name;

    static {
        LOG.logDebug("CP211x Library Version    :", Device211x.getLibraryVersion());
        LOG.logDebug("CP211x HID Library Version:", Device211x.getHidLibraryVersion());
    }

    public static synchronized List<Device> getDevices() {
        Device211x.checkDeviceDetection();
        LinkedList<Device> result = new LinkedList<Device>();
        int numDevices = Device211x.getNumDevices();
        int i = 0;
        while (i < numDevices) {
            try {
                String serial = Device211x.getSerial(i);
                PartNumber part = Device211x.getPartNumber(i);
                if (part.number == 10) {
                    result.add(new Device2110(serial));
                } else if (part.number == 14) {
                    Device2114 dev2114 = new Device2114(serial);
                    Device2114.DeviceVersions vers = Device2114.getVersions(dev2114);
                    dev2114.setVersions(vers);
                    result.add(dev2114);
                }
            }
            catch (Exception exception) {}
            ++i;
        }
        return result;
    }

    @Override
    protected Property[] createPortConfigs() {
        Property[] result = new Property[]{};
        return result;
    }

    @Override
    protected Property[] createBaudConfigs() {
        Property[] result = new Property[]{};
        return result;
    }

    @Override
    public final synchronized String getFlushBuffers(Device deviceObj) throws Exception {
        Device211x.checkDeviceDetection();
        Pointer device = Device211x.openDevice((Device211x)deviceObj);
        IntByReference vid = new IntByReference();
        IntByReference pid = new IntByReference();
        ByteByReference power = new ByteByReference();
        ByteByReference powerMode = new ByteByReference();
        IntByReference releaseVersion = new IntByReference();
        ByteByReference flushBuffers = new ByteByReference();
        int status = SLABHIDtoUART.DLL.HidUart_GetUsbConfig(device, vid, pid, power, powerMode, releaseVersion, flushBuffers);
        Device211x.close(device);
        String result = status == 0 ? Device211x.toHexString(flushBuffers.getValue(), 2) : "";
        LOG.logDebug(status, "getFlushBuffers:", result);
        if (status != 0) {
            throw new Exception("getFlushBuffers(" + deviceObj + "): " + status);
        }
        return result;
    }

    @Override
    public final synchronized String getManufacturer(Device deviceObj) throws Exception {
        Device211x.checkDeviceDetection();
        Pointer device = Device211x.openDevice((Device211x)deviceObj);
        byte[] manufacturingString = new byte[62];
        ByteByReference strlen = new ByteByReference();
        int status = SLABHIDtoUART.DLL.HidUart_GetManufacturingString(device, manufacturingString, strlen);
        Device211x.close(device);
        String result = status == 0 ? Native.toString((byte[])manufacturingString) : "";
        LOG.logDebug(status, "getManufacturer:", result);
        if (status != 0) {
            throw new Exception("getManufacturer(" + deviceObj + "): " + status);
        }
        return result;
    }

    @Override
    public final synchronized String getPID(Device deviceObj) throws Exception {
        Device211x.checkDeviceDetection();
        Pointer device = Device211x.openDevice((Device211x)deviceObj);
        IntByReference vid = new IntByReference();
        IntByReference pid = new IntByReference();
        ByteByReference power = new ByteByReference();
        ByteByReference powerMode = new ByteByReference();
        IntByReference releaseVersion = new IntByReference();
        ByteByReference flushBuffers = new ByteByReference();
        int status = SLABHIDtoUART.DLL.HidUart_GetUsbConfig(device, vid, pid, power, powerMode, releaseVersion, flushBuffers);
        Device211x.close(device);
        String result = status == 0 ? Device211x.toHexString(pid.getValue(), 4) : "";
        LOG.logDebug(status, "getPID:", result);
        if (status != 0) {
            throw new Exception("getPID(" + deviceObj + "): " + status);
        }
        return result;
    }

    @Override
    public final synchronized String getPower(Device deviceObj) throws Exception {
        Device211x.checkDeviceDetection();
        Pointer device = Device211x.openDevice((Device211x)deviceObj);
        IntByReference vid = new IntByReference();
        IntByReference pid = new IntByReference();
        ByteByReference power = new ByteByReference();
        ByteByReference powerMode = new ByteByReference();
        IntByReference releaseVersion = new IntByReference();
        ByteByReference flushBuffers = new ByteByReference();
        int status = SLABHIDtoUART.DLL.HidUart_GetUsbConfig(device, vid, pid, power, powerMode, releaseVersion, flushBuffers);
        Device211x.close(device);
        String result = status == 0 ? Device211x.toHexString(power.getValue(), 2) : "";
        LOG.logDebug(status, "getPower:", result);
        if (status != 0) {
            throw new Exception("getPower(" + deviceObj + "): " + status);
        }
        return result;
    }

    @Override
    public final synchronized String getPowerMode(Device deviceObj) throws Exception {
        Device211x.checkDeviceDetection();
        Pointer device = Device211x.openDevice((Device211x)deviceObj);
        IntByReference vid = new IntByReference();
        IntByReference pid = new IntByReference();
        ByteByReference power = new ByteByReference();
        ByteByReference powerMode = new ByteByReference();
        IntByReference releaseVersion = new IntByReference();
        ByteByReference flushBuffers = new ByteByReference();
        int status = SLABHIDtoUART.DLL.HidUart_GetUsbConfig(device, vid, pid, power, powerMode, releaseVersion, flushBuffers);
        Device211x.close(device);
        String result = status == 0 ? Device211x.toHexString(powerMode.getValue(), 2) : "";
        LOG.logDebug(status, "getPowerMode:", result);
        if (status != 0) {
            throw new Exception("getPowerMode(" + deviceObj + "): " + status);
        }
        return result;
    }

    @Override
    public final synchronized String getProduct(Device deviceObj) throws Exception {
        Device211x.checkDeviceDetection();
        Pointer device = Device211x.openDevice((Device211x)deviceObj);
        byte[] productString = new byte[62];
        ByteByReference strlen = new ByteByReference();
        int status = SLABHIDtoUART.DLL.HidUart_GetProductString(device, productString, strlen);
        Device211x.close(device);
        String result = status == 0 ? Native.toString((byte[])productString) : "";
        LOG.logDebug(status, "getProduct:", result);
        if (status != 0) {
            throw new Exception("getProduct(" + deviceObj + "): " + status);
        }
        return result;
    }

    @Override
    public final synchronized String getReleaseVersion(Device deviceObj) throws Exception {
        Device211x.checkDeviceDetection();
        Pointer device = Device211x.openDevice((Device211x)deviceObj);
        IntByReference vid = new IntByReference();
        IntByReference pid = new IntByReference();
        ByteByReference power = new ByteByReference();
        ByteByReference powerMode = new ByteByReference();
        IntByReference releaseVersion = new IntByReference();
        ByteByReference flushBuffers = new ByteByReference();
        int status = SLABHIDtoUART.DLL.HidUart_GetUsbConfig(device, vid, pid, power, powerMode, releaseVersion, flushBuffers);
        Device211x.close(device);
        String result = "";
        if (status == 0) {
            result = Device211x.toHexString(releaseVersion.getValue(), 4);
        }
        LOG.logDebug(status, "getRelease:", result);
        if (status != 0) {
            throw new Exception("getRelease(" + deviceObj + "): " + status);
        }
        return result;
    }

    @Override
    public final synchronized String getSerial(Device deviceObj) throws Exception {
        Device211x.checkDeviceDetection();
        Pointer device = Device211x.openDevice((Device211x)deviceObj);
        byte[] serialString = new byte[30];
        ByteByReference strlen = new ByteByReference();
        int status = SLABHIDtoUART.DLL.HidUart_GetSerialString(device, serialString, strlen);
        Device211x.close(device);
        String result = status == 0 ? Native.toString((byte[])serialString) : "";
        LOG.logDebug(status, "getSerial:", result);
        if (status != 0) {
            throw new Exception("getSerial(" + deviceObj + "): " + status);
        }
        return result;
    }

    @Override
    public final synchronized String getVID(Device deviceObj) throws Exception {
        Device211x.checkDeviceDetection();
        Pointer device = Device211x.openDevice((Device211x)deviceObj);
        IntByReference vid = new IntByReference();
        IntByReference pid = new IntByReference();
        ByteByReference power = new ByteByReference();
        ByteByReference powerMode = new ByteByReference();
        IntByReference releaseVersion = new IntByReference();
        ByteByReference flushBuffers = new ByteByReference();
        int status = SLABHIDtoUART.DLL.HidUart_GetUsbConfig(device, vid, pid, power, powerMode, releaseVersion, flushBuffers);
        Device211x.close(device);
        String result = status == 0 ? Device211x.toHexString(vid.getValue(), 4) : "";
        LOG.logDebug(status, "getVID:", result);
        if (status != 0) {
            throw new Exception("getVID(" + deviceObj + "): " + status);
        }
        return result;
    }

    @Override
    public final synchronized void setManufacturer(Device deviceObj, String manufacturer) throws Exception {
        Device211x.checkDeviceDetection();
        Pointer device = Device211x.openDevice((Device211x)deviceObj);
        byte[] manuStr = Native.toByteArray((String)manufacturer);
        int status = 5;
        if (manuStr.length < 127) {
            byte strlen = (byte)manuStr.length;
            status = SLABHIDtoUART.DLL.HidUart_SetManufacturingString(device, manuStr, strlen);
        }
        Device211x.close(device);
        LOG.logDebug(status, "setManufacturer:", Arrays.toString(manuStr));
        if (status != 0) {
            throw new Exception("setManufacturer(" + deviceObj + "): " + status);
        }
    }

    @Override
    public final synchronized void setProduct(Device deviceObj, String product) throws Exception {
        Device211x.checkDeviceDetection();
        Pointer device = Device211x.openDevice((Device211x)deviceObj);
        byte[] prodStr = Native.toByteArray((String)product);
        int status = 5;
        if (prodStr.length < 127) {
            byte strlen = (byte)prodStr.length;
            status = SLABHIDtoUART.DLL.HidUart_SetProductString(device, prodStr, strlen);
        }
        Device211x.close(device);
        LOG.logDebug(status, "setProduct:", Arrays.toString(prodStr));
        if (status != 0) {
            throw new Exception("setProduct(" + deviceObj + "): " + status);
        }
    }

    @Override
    public final synchronized void setSerial(Device deviceObj, String serial) throws Exception {
        Device211x.checkDeviceDetection();
        Pointer device = Device211x.openDevice((Device211x)deviceObj);
        byte[] serialStr = Native.toByteArray((String)serial);
        int status = 5;
        if (serialStr.length < 127) {
            byte strlen = (byte)serialStr.length;
            status = SLABHIDtoUART.DLL.HidUart_SetSerialString(device, serialStr, strlen);
        }
        Device211x.close(device);
        LOG.logDebug(status, "setSerial:", Arrays.toString(serialStr));
        if (status != 0) {
            throw new Exception("setSerial(" + deviceObj + "): " + status);
        }
    }

    @Override
    public final synchronized void setFlushBuffers(Device deviceObj, String value) throws Exception {
        Device211x.checkDeviceDetection();
        Pointer device = Device211x.openDevice((Device211x)deviceObj);
        int vid = 0;
        int pid = 0;
        byte power = 0;
        byte powerMode = 0;
        int releaseVersion = 0;
        byte flushBuffers = Byte.parseByte(value, 16);
        int status = SLABHIDtoUART.DLL.HidUart_SetUsbConfig(device, vid, pid, power, powerMode, releaseVersion, flushBuffers, (byte)32);
        Device211x.close(device);
        LOG.logDebug(status, "setFlushBuffers:", value);
        if (status != 0) {
            throw new Exception("setFlushBuffers(" + deviceObj + "): " + status);
        }
    }

    @Override
    public final synchronized void setReleaseVersion(Device deviceObj, String value) throws Exception {
        Device211x.checkDeviceDetection();
        Pointer device = Device211x.openDevice((Device211x)deviceObj);
        int vid = 0;
        int pid = 0;
        byte power = 0;
        byte powerMode = 0;
        int releaseVersion = Integer.parseInt(value, 16);
        byte flushBuffers = 0;
        int status = SLABHIDtoUART.DLL.HidUart_SetUsbConfig(device, vid, pid, power, powerMode, releaseVersion, flushBuffers, (byte)16);
        Device211x.close(device);
        LOG.logDebug(status, "setReleaseVersion:", value);
        if (status != 0) {
            throw new Exception("setReleaseVersion(" + deviceObj + "): " + status);
        }
    }

    @Override
    public final synchronized void setPID(Device deviceObj, String value) throws Exception {
        Device211x.checkDeviceDetection();
        Pointer device = Device211x.openDevice((Device211x)deviceObj);
        int vid = 0;
        int pid = Integer.parseInt(value, 16);
        byte power = 0;
        byte powerMode = 0;
        int releaseVersion = 0;
        byte flushBuffers = 0;
        int status = SLABHIDtoUART.DLL.HidUart_SetUsbConfig(device, vid, pid, power, powerMode, releaseVersion, flushBuffers, (byte)2);
        Device211x.close(device);
        LOG.logDebug(status, "setPID:", value);
        if (status != 0) {
            throw new Exception("setPID(" + deviceObj + "): " + status);
        }
    }

    @Override
    public final synchronized void setVID(Device deviceObj, String value) throws Exception {
        Device211x.checkDeviceDetection();
        Pointer device = Device211x.openDevice((Device211x)deviceObj);
        int vid = Integer.parseInt(value, 16);
        int pid = 0;
        byte power = 0;
        byte powerMode = 0;
        int releaseVersion = 0;
        byte flushBuffers = 0;
        int status = SLABHIDtoUART.DLL.HidUart_SetUsbConfig(device, vid, pid, power, powerMode, releaseVersion, flushBuffers, (byte)1);
        Device211x.close(device);
        LOG.logDebug(status, "setVID:", value);
        if (status != 0) {
            throw new Exception("setVID(" + deviceObj + "): " + status);
        }
    }

    @Override
    public final synchronized void setPower(Device deviceObj, String value) throws Exception {
        Device211x.checkDeviceDetection();
        Pointer device = Device211x.openDevice((Device211x)deviceObj);
        int vid = 0;
        int pid = 0;
        byte power = Byte.parseByte(value, 16);
        byte powerMode = 0;
        int releaseVersion = 0;
        byte flushBuffers = 0;
        int status = SLABHIDtoUART.DLL.HidUart_SetUsbConfig(device, vid, pid, power, powerMode, releaseVersion, flushBuffers, (byte)4);
        Device211x.close(device);
        LOG.logDebug(status, "setPower:", value);
        if (status != 0) {
            throw new Exception("setPower(" + deviceObj + "): " + status);
        }
    }

    @Override
    public final synchronized void setPowerMode(Device deviceObj, String value) throws Exception {
        Device211x.checkDeviceDetection();
        Pointer device = Device211x.openDevice((Device211x)deviceObj);
        int vid = 0;
        int pid = 0;
        byte power = 0;
        byte powerMode = Byte.parseByte(value, 16);
        int releaseVersion = 0;
        byte flushBuffers = 0;
        int status = SLABHIDtoUART.DLL.HidUart_SetUsbConfig(device, vid, pid, power, powerMode, releaseVersion, flushBuffers, (byte)8);
        Device211x.close(device);
        LOG.logDebug(status, "setPowerMode:", value);
        if (status != 0) {
            throw new Exception("setPowerMode(" + deviceObj + "): " + status);
        }
    }

    protected static synchronized void checkDeviceDetection() {
        if (!DeviceDetector.getDefault().isStopped()) {
            new IllegalStateException("Device detection still active");
        }
    }

    protected static synchronized void close(Pointer device) {
        if (device != null) {
            SLABHIDtoUART.DLL.HidUart_Close(device);
        }
    }

    private static synchronized Object getHidLibraryVersion() {
        String result = "";
        IntByReference major = new IntByReference();
        IntByReference minor = new IntByReference();
        IntByReference release = new IntByReference();
        int status = SLABHIDtoUART.DLL.HidUart_GetHidLibraryVersion(major, minor, release);
        if (status == 0) {
            String strRelease = release.getValue() > 0 ? "release" : "debug";
            result = String.format("%d.%d-%s", major.getValue(), minor.getValue(), strRelease);
        }
        return result;
    }

    private static synchronized Object getLibraryVersion() {
        String result = "";
        IntByReference major = new IntByReference();
        IntByReference minor = new IntByReference();
        IntByReference release = new IntByReference();
        int status = SLABHIDtoUART.DLL.HidUart_GetLibraryVersion(major, minor, release);
        if (status == 0) {
            String strRelease = release.getValue() > 0 ? "release" : "debug";
            result = String.format("%d.%d-%s", major.getValue(), minor.getValue(), strRelease);
        }
        return result;
    }

    private static synchronized int getNumDevices() {
        IntByReference numDevices = new IntByReference();
        int vid = 0;
        int pid = 0;
        int status = SLABHIDtoUART.DLL.HidUart_GetNumDevices(numDevices, vid, pid);
        if (status != 0) {
            numDevices.setValue(0);
        }
        return numDevices.getValue();
    }

    private static synchronized PartNumber getPartNumber(int deviceNum) throws Exception {
        Pointer device = Device211x.open(deviceNum);
        IntByReference partNumber = new IntByReference();
        IntByReference version = new IntByReference();
        int status = SLABHIDtoUART.DLL.HidUart_GetPartNumber(device, partNumber, version);
        Device211x.close(device);
        if (status != 0) {
            throw new Exception("getPartNumber(" + deviceNum + "): " + status);
        }
        return new PartNumber(partNumber.getValue(), version.getValue());
    }

    private static synchronized String getSerial(int deviceNum) throws Exception {
        String result;
        int vid = 0;
        int pid = 0;
        byte[] deviceString = new byte[512];
        int status = SLABHIDtoUART.DLL.HidUart_GetString(deviceNum, vid, pid, deviceString, (short)4);
        String string = result = status == 0 ? Native.toString((byte[])deviceString) : "";
        if (status != 0) {
            throw new Exception("getSerial(" + deviceNum + "): " + status);
        }
        return result;
    }

    private static synchronized Pointer open(int deviceNum) throws Exception {
        PointerByReference devicePtr = new PointerByReference();
        int vid = 0;
        int pid = 0;
        int status = SLABHIDtoUART.DLL.HidUart_Open(devicePtr, deviceNum, vid, pid);
        if (status != 0) {
            throw new Exception("open(" + deviceNum + "): " + status);
        }
        return devicePtr.getValue();
    }

    protected static synchronized Pointer openDevice(Device211x device) throws Exception {
        Pointer result = null;
        int numDevices = Device211x.getNumDevices();
        int i = 0;
        while (i < numDevices && result == null) {
            try {
                String serial = Device211x.getSerial(i);
                if (device.getSerial().equals(serial)) {
                    result = Device211x.open(i);
                }
            }
            catch (Exception exception) {}
            ++i;
        }
        if (result == null) {
            throw new Exception("Device not found: " + device);
        }
        return result;
    }

    @Override
    public void resetDevice() throws Exception {
        Device211x.checkDeviceDetection();
        Pointer device = Device211x.openDevice(this);
        int status = SLABHIDtoUART.DLL.HidUart_Reset(device);
        Device211x.close(device);
        String result = status == 0 || status == 20 ? "Success" : "Failed";
        LOG.logDebug(status, "resetDevice:", result);
        if (status != 0 && status != 20) {
            throw new Exception("resetDevice(" + this + "): " + status);
        }
        DeviceDetector.getDefault().startWaitForReset();
        int timeoutMilliseconds = 20000;
        while (DeviceDetector.getDefault().isWaitingForReset() && timeoutMilliseconds > 0) {
            Thread.sleep(100L);
            DeviceDetector.getDefault().start();
            timeoutMilliseconds -= 100;
        }
        if (DeviceDetector.getDefault().isWaitingForReset()) {
            DeviceDetector.getDefault().cancelWaitForReset();
            throw new Exception("resetDevice(" + this + "): - Device never came back from reset");
        }
    }

    @Override
    public String getInterfaceString(Device device, int interfaceNumber) throws Exception {
        return null;
    }

    @Override
    public void setInterfaceString(Device device, int interfaceNumber, String value) throws Exception {
    }

    @Override
    public String getDeviceMode(Device device) throws Exception {
        return null;
    }

    @Override
    public void setDeviceMode(Device device, String value) throws Exception {
    }

    @Override
    public String getTransferPriority(Device device) throws Exception {
        return null;
    }

    @Override
    public void setTransferPriority(Device device, String value) throws Exception {
    }

    @Override
    public String getDeviceString() {
        return this.getName();
    }

    @Override
    public void setBaudConfig(Device deviceObj, CP210xBaudConfig writeConfig) throws Exception {
    }

    @Override
    public CP210xBaudConfig getBaudConfig(Device deviceObj) throws Exception {
        return null;
    }

    protected static String toHexString(int value, int digits) {
        String result = String.format("%X", value);
        int diff = digits - result.length();
        while (diff > 0) {
            result = "0" + result;
            --diff;
        }
        return result;
    }

    protected Device211x(String serial) {
        this.setSerial(serial);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String newName) {
        this.name = newName;
    }

    @Override
    public String getSerial() {
        return this.serial;
    }

    @Override
    public void setSerial(String serial) {
        if (serial == null) {
            throw new NullPointerException("serial");
        }
        this.serial = serial;
        this.name = String.valueOf(this.getType()) + " - " + serial;
    }

    private static final class PartNumber {
        private final int number;
        private final int version;

        public PartNumber(int number, int version) {
            this.number = number;
            this.version = version;
        }
    }
}

