/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.customizer.devices.cp211x;

import com.silabs.customizer.Application;
import com.silabs.customizer.devices.Device;
import com.silabs.customizer.devices.GroupPortConfigRoot;
import com.silabs.customizer.devices.Property;
import com.silabs.customizer.devices.PropertyClockDivider;
import com.silabs.customizer.devices.PropertySuspendMode;
import com.silabs.customizer.devices.PropertySuspendValue;
import com.silabs.customizer.devices.PropertyToggleValues;
import com.silabs.customizer.devices.cp211x.CP2114GroupPins;
import com.silabs.customizer.devices.cp211x.CP2114PinConfig;
import com.silabs.customizer.devices.cp211x.CP2114SuspendModeCellEditor;
import com.silabs.customizer.devices.cp211x.CP2114SuspendValueCellEditor;
import com.silabs.customizer.devices.cp211x.Device2114;
import com.silabs.customizer.log.MessageLog;

class CP2114GroupPortConfigRoot
extends GroupPortConfigRoot {
    public CP2114GroupPortConfigRoot(Device device) {
        super(device, "CP2114PortConfigGroup");
        Property[] propertyArray = new Property[5];
        this.grpPins = new CP2114GroupPins(device);
        propertyArray[0] = this.grpPins;
        this.pUseSuspend = new PropertyToggleValues(device, "Use Suspend Values", "no", "use suspend value/mode");
        propertyArray[1] = this.pUseSuspend;
        this.pSuspendValue = new PropertySuspendValue(device, CP2114SuspendValueCellEditor.getFactory());
        propertyArray[2] = this.pSuspendValue;
        this.pSuspendMode = new PropertySuspendMode(device, CP2114SuspendModeCellEditor.getFactory());
        propertyArray[3] = this.pSuspendMode;
        this.pClockDivider = new PropertyClockDivider(device);
        propertyArray[4] = this.pClockDivider;
        this.children = propertyArray;
        this.pinCount = 14;
        this.initProperty();
    }

    @Override
    public void program() {
        if (!this.isChanged() || this.isError()) {
            return;
        }
        CP2114PinConfig writeConfig = null;
        try {
            writeConfig = this.createPinConfig();
            if (Application.DRY_RUN) {
                this.updateDefaults(writeConfig);
            } else {
                Device2114.setPinConfig(this.getDevice(), writeConfig);
                CP2114PinConfig newDefaults = this.readPinConfig();
                this.updateDefaults(newDefaults);
            }
            this.updateWritten(true);
            this.updateError();
            this.logWrite(this.isError(), null, writeConfig);
        }
        catch (Exception exc) {
            this.logWrite(true, exc, writeConfig);
        }
    }

    @Override
    protected String readValueFromDevice() throws Exception {
        if (this.children != null) {
            CP2114PinConfig config = this.readPinConfig();
            this.updateDefaults(config);
            this.updateValues(config);
        }
        return "";
    }

    private CP2114PinConfig createPinConfig() {
        Property[] pPins = this.grpPins.getChildren();
        if (pPins.length != this.pinCount) {
            throw new IllegalStateException("Error in number of configurable pins!");
        }
        byte[] pinConfigs = new byte[pPins.length];
        int i = 0;
        while (i < pinConfigs.length) {
            pinConfigs[i] = Byte.parseByte(pPins[i].getValue(), 16);
            ++i;
        }
        int useSuspend = Integer.parseInt(this.pUseSuspend.getValue(), 16);
        int suspendValue = Integer.parseInt(this.pSuspendValue.getValue(), 16);
        int suspendMode = Integer.parseInt(this.pSuspendMode.getValue(), 16);
        short clkDiv = Short.parseShort(this.pClockDivider.getValue(), 16);
        return new CP2114PinConfig(pinConfigs, useSuspend, suspendValue, suspendMode, clkDiv);
    }

    private final void logWrite(boolean error, Exception exc, CP2114PinConfig config) {
        if (!error) {
            MessageLog.info(String.format("%s Successul write of %s: %s", this.getDevice().getType(), this.getName(), config));
        } else {
            String message = String.format("%s FAILED write of %s: %s", this.getDevice().getType(), this.getName(), config);
            MessageLog.error(message, exc);
        }
    }

    private CP2114PinConfig readPinConfig() throws Exception {
        return Device2114.getPinConfig(this.getDevice());
    }

    private void updateDefaults(CP2114PinConfig config) {
        Property[] pPins = this.grpPins.getChildren();
        if (pPins.length != this.pinCount) {
            throw new IllegalStateException("Error in number of configurable pins!");
        }
        int i = 0;
        while (i < pPins.length) {
            String pinValue = String.format("%02X", config.pinConfigs[i]);
            pPins[i].setDefaultValue(pinValue);
            ++i;
        }
        this.pUseSuspend.setDefaultValue(String.valueOf(config.useSuspendValues));
        this.pSuspendValue.setDefaultValue(String.format("%04X", config.suspendValue));
        this.pSuspendMode.setDefaultValue(String.format("%04X", config.suspendMode));
        this.pClockDivider.setDefaultValue(String.format("%02X", config.clkDiv));
    }

    private void updateError() {
        Property[] props;
        Property[] propertyArray = this.grpPins.getChildren();
        int n = propertyArray.length;
        int n2 = 0;
        while (n2 < n) {
            Property prop = propertyArray[n2];
            boolean error = !prop.getDefaultValue().equals(prop.getValue());
            prop.setError(error);
            ++n2;
        }
        Property[] propertyArray2 = props = new Property[]{this.pUseSuspend, this.pSuspendValue, this.pSuspendMode, this.pClockDivider};
        int n3 = props.length;
        n = 0;
        while (n < n3) {
            Property prop = propertyArray2[n];
            boolean error = !prop.getDefaultValue().equals(prop.getValue());
            prop.setError(error);
            ++n;
        }
    }

    private void updateValues(CP2114PinConfig config) {
        Property[] pPins = this.grpPins.getChildren();
        if (pPins.length != this.pinCount) {
            throw new IllegalStateException("Error in number of configurable pins!");
        }
        int i = 0;
        while (i < pPins.length) {
            String pinValue = String.format("%02X", config.pinConfigs[i]);
            pPins[i].setValue(pinValue);
            ++i;
        }
        this.pUseSuspend.setValue(String.valueOf(config.useSuspendValues));
        this.pSuspendValue.setValue(String.format("%04X", config.suspendValue));
        this.pSuspendMode.setValue(String.format("%04X", config.suspendMode));
        this.pClockDivider.setValue(String.format("%02X", config.clkDiv));
    }

    private void updateWritten(boolean written) {
        Property[] propertyArray = this.grpPins.getChildren();
        int n = propertyArray.length;
        int n2 = 0;
        while (n2 < n) {
            Property prop = propertyArray[n2];
            prop.setWritten(written);
            ++n2;
        }
        this.pUseSuspend.setWritten(written);
        this.pSuspendValue.setWritten(written);
        this.pSuspendMode.setWritten(written);
        this.pClockDivider.setWritten(written);
    }

    @Override
    public void resetSiliconLabsDefaultValues() {
        Property[] pPins = this.grpPins.getChildren();
        if (pPins.length != this.pinCount) {
            throw new IllegalStateException("Error in number of configurable pins!");
        }
        pPins[0].reset("03");
        pPins[1].reset("03");
        pPins[2].reset("03");
        pPins[3].reset("03");
        pPins[4].reset("03");
        pPins[5].reset("04");
        pPins[6].reset("04");
        pPins[7].reset("04");
        pPins[8].reset("04");
        pPins[9].reset("03");
        pPins[10].reset("04");
        pPins[11].reset("03");
        pPins[12].reset("02");
        pPins[13].reset("02");
        this.pUseSuspend.reset("0");
        this.pSuspendValue.reset("0000");
        this.pSuspendMode.reset("0000");
        this.pClockDivider.reset("00");
    }
}

