/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.customizer.devices.cp210x;

import com.silabs.customizer.Application;
import com.silabs.customizer.devices.Device;
import com.silabs.customizer.devices.GroupPortConfigRoot;
import com.silabs.customizer.devices.Property;
import com.silabs.customizer.devices.PropertyToggleValues;
import com.silabs.customizer.devices.cp210x.CP2108GroupInterface;
import com.silabs.customizer.devices.cp210x.CP2108GroupPins;
import com.silabs.customizer.devices.cp210x.CP2108PinConfig;
import com.silabs.customizer.devices.cp210x.Device2108;
import com.silabs.customizer.log.MessageLog;

class CP2108GroupPortConfigRoot
extends GroupPortConfigRoot {
    public CP2108GroupPortConfigRoot(Device device) {
        super(device, "CP2108PortConfigGroup");
        Property[] propertyArray = new Property[8];
        this.grpIfc[0] = new CP2108GroupInterface(device, 0);
        propertyArray[0] = this.grpIfc[0];
        this.grpIfc[1] = new CP2108GroupInterface(device, 1);
        propertyArray[1] = this.grpIfc[1];
        this.grpIfc[2] = new CP2108GroupInterface(device, 2);
        propertyArray[2] = this.grpIfc[2];
        this.grpIfc[3] = new CP2108GroupInterface(device, 3);
        propertyArray[3] = this.grpIfc[3];
        this.grpPins = new CP2108GroupPins(device);
        propertyArray[4] = this.grpPins;
        this.pEnableWeakPullUpReset = new PropertyToggleValues(device, "Device Weak Pull-Up on Reset", "disable", "enable");
        propertyArray[5] = this.pEnableWeakPullUpReset;
        this.pEnableWeakPullUpSuspend = new PropertyToggleValues(device, "Device Weak Pull-Up on Suspend", "disable", "enable");
        propertyArray[6] = this.pEnableWeakPullUpSuspend;
        this.pUseSuspend = new PropertyToggleValues(device, "Device Dynamic Suspend", "no", "use suspend value");
        propertyArray[7] = this.pUseSuspend;
        this.children = propertyArray;
        this.initProperty();
    }

    @Override
    public void program() {
        if (!this.isChanged() || this.isError()) {
            return;
        }
        CP2108PinConfig writeConfig = null;
        try {
            writeConfig = this.createPinConfig();
            if (Application.DRY_RUN) {
                this.updateDefaults(writeConfig);
            } else {
                Device2108.setPinConfig(this.getDevice(), writeConfig);
                CP2108PinConfig newDefaults = this.readPinConfig();
                this.updateDefaults(newDefaults);
            }
            this.updateWritten(true);
            this.updateError();
            this.logWrite(this.isError(), null, writeConfig);
        }
        catch (Exception exc) {
            this.logWrite(true, exc, writeConfig);
        }
    }

    @Override
    protected String readValueFromDevice() throws Exception {
        if (this.children != null) {
            CP2108PinConfig config = this.readPinConfig();
            this.updateDefaults(config);
            this.updateValues(config);
        }
        return "";
    }

    private CP2108PinConfig createPinConfig() {
        int[] resetMode = new int[5];
        int[] resetLowPower = new int[5];
        int[] resetValue = new int[5];
        int[] suspendMode = new int[5];
        int[] suspendLowPower = new int[5];
        int[] suspendValue = new int[5];
        int[] ipDelay = new int[4];
        int[] txLEDAutoMode = new int[4];
        int[] rxLEDAutoMode = new int[4];
        int[] rs485AutoMode = new int[4];
        int[] rs485Invert = new int[4];
        int[] useClock = new int[4];
        int[] useSuspendValues = new int[4];
        int[] extClk = new int[4];
        int i = 0;
        while (i < this.grpIfc.length) {
            resetMode[i] = Integer.parseInt(this.grpIfc[i].pResetMode.getValue(), 16);
            resetLowPower[i] = Integer.parseInt(this.grpIfc[i].pResetLowPower.getValue(), 16);
            resetValue[i] = Integer.parseInt(this.grpIfc[i].pResetValue.getValue(), 16);
            suspendMode[i] = Integer.parseInt(this.grpIfc[i].pSuspendMode.getValue(), 16);
            suspendLowPower[i] = Integer.parseInt(this.grpIfc[i].pSuspendLowPower.getValue(), 16);
            suspendValue[i] = Integer.parseInt(this.grpIfc[i].pSuspendValue.getValue(), 16);
            ipDelay[i] = Integer.parseInt(this.grpIfc[i].pIPDelay.getValue(), 16);
            txLEDAutoMode[i] = Integer.parseInt(this.grpIfc[i].pTXLEDAutoMode.getValue(), 16);
            rxLEDAutoMode[i] = Integer.parseInt(this.grpIfc[i].pRXLEDAutoMode.getValue(), 16);
            rs485AutoMode[i] = Integer.parseInt(this.grpIfc[i].pRS485AutoMode.getValue(), 16);
            rs485Invert[i] = Integer.parseInt(this.grpIfc[i].pRS485Invert.getValue(), 16);
            useClock[i] = Integer.parseInt(this.grpIfc[i].pGPIOClockEnable.getValue(), 16);
            useSuspendValues[i] = Integer.parseInt(this.grpIfc[i].pUseDynamicSuspend.getValue(), 16);
            extClk[i] = Integer.parseInt(this.grpIfc[i].pClockDivider.getValue(), 16);
            ++i;
        }
        resetMode[4] = Integer.parseInt(this.grpPins.pResetMode.getValue(), 16);
        resetLowPower[4] = Integer.parseInt(this.grpPins.pResetLowPower.getValue(), 16);
        resetValue[4] = Integer.parseInt(this.grpPins.pResetValue.getValue(), 16);
        suspendMode[4] = Integer.parseInt(this.grpPins.pSuspendMode.getValue(), 16);
        suspendLowPower[4] = Integer.parseInt(this.grpPins.pSuspendLowPower.getValue(), 16);
        suspendValue[4] = Integer.parseInt(this.grpPins.pSuspendValue.getValue(), 16);
        int enableWeakPullUpReset = Integer.parseInt(this.pEnableWeakPullUpReset.getValue(), 16);
        int enableWeakPullUpSuspend = Integer.parseInt(this.pEnableWeakPullUpSuspend.getValue(), 16);
        int enableDynamicSuspend = Integer.parseInt(this.pUseSuspend.getValue(), 16);
        return new CP2108PinConfig(resetMode, resetLowPower, resetValue, suspendMode, suspendLowPower, suspendValue, ipDelay, txLEDAutoMode, rxLEDAutoMode, rs485AutoMode, rs485Invert, useClock, useSuspendValues, enableWeakPullUpReset, enableWeakPullUpSuspend, enableDynamicSuspend, extClk);
    }

    private final void logWrite(boolean error, Exception exc, CP2108PinConfig config) {
        if (!error) {
            MessageLog.info(String.format("%s Successul write of %s: %s", this.getDevice().getType(), this.getName(), config));
        } else {
            String message = String.format("%s FAILED write of %s: %s", this.getDevice().getType(), this.getName(), config);
            MessageLog.error(message, exc);
        }
    }

    private CP2108PinConfig readPinConfig() throws Exception {
        return Device2108.getPinConfig(this.getDevice());
    }

    private void updateDefaults(CP2108PinConfig config) {
        int i = 0;
        while (i < this.grpIfc.length) {
            this.grpIfc[i].pResetMode.setDefaultValue(String.format("%02X", config.resetMode[i]));
            this.grpIfc[i].pResetLowPower.setDefaultValue(String.format("%02X", config.resetLowPower[i]));
            this.grpIfc[i].pResetValue.setDefaultValue(String.format("%02X", config.resetValue[i]));
            this.grpIfc[i].pSuspendMode.setDefaultValue(String.format("%02X", config.suspendMode[i]));
            this.grpIfc[i].pSuspendLowPower.setDefaultValue(String.format("%02X", config.suspendLowPower[i]));
            this.grpIfc[i].pSuspendValue.setDefaultValue(String.format("%02X", config.suspendValue[i]));
            this.grpIfc[i].pIPDelay.setDefaultValue(String.format("%02X", config.ipDelay[i]));
            this.grpIfc[i].pTXLEDAutoMode.setDefaultValue(String.valueOf(config.txLEDAutoMode[i]));
            this.grpIfc[i].pRXLEDAutoMode.setDefaultValue(String.valueOf(config.rxLEDAutoMode[i]));
            this.grpIfc[i].pRS485AutoMode.setDefaultValue(String.valueOf(config.rs485AutoMode[i]));
            this.grpIfc[i].pRS485Invert.setDefaultValue(String.valueOf(config.rs485Invert[i]));
            this.grpIfc[i].pGPIOClockEnable.setDefaultValue(String.valueOf(config.useClock[i]));
            this.grpIfc[i].pUseDynamicSuspend.setDefaultValue(String.valueOf(config.useSuspendValues[i]));
            this.grpIfc[i].pClockDivider.setDefaultValue(String.format("%02X", config.extClk[i]));
            ++i;
        }
        this.grpPins.pResetMode.setDefaultValue(String.format("%04X", config.resetMode[4]));
        this.grpPins.pResetLowPower.setDefaultValue(String.format("%04X", config.resetLowPower[4]));
        this.grpPins.pResetValue.setDefaultValue(String.format("%04X", config.resetValue[4]));
        this.grpPins.pSuspendMode.setDefaultValue(String.format("%04X", config.suspendMode[4]));
        this.grpPins.pSuspendLowPower.setDefaultValue(String.format("%04X", config.suspendLowPower[4]));
        this.grpPins.pSuspendValue.setDefaultValue(String.format("%04X", config.suspendValue[4]));
        this.pEnableWeakPullUpReset.setDefaultValue(String.valueOf(config.enableWeakPullUpReset));
        this.pEnableWeakPullUpSuspend.setDefaultValue(String.valueOf(config.enableWeakPullUpSuspend));
        this.pUseSuspend.setDefaultValue(String.valueOf(config.enableDynamicSuspend));
    }

    private void updateError() {
        boolean error;
        int n;
        Property[] propertyArray;
        int i = 0;
        while (i < this.grpIfc.length) {
            propertyArray = this.grpIfc[i].getChildren();
            int n2 = propertyArray.length;
            n = 0;
            while (n < n2) {
                Property prop = propertyArray[n];
                error = !prop.getDefaultValue().equals(prop.getValue());
                prop.setError(error);
                ++n;
            }
            ++i;
        }
        Property[] propertyArray2 = this.grpPins.getChildren();
        n = propertyArray2.length;
        int prop = 0;
        while (prop < n) {
            Property prop2 = propertyArray2[prop];
            boolean error2 = !prop2.getDefaultValue().equals(prop2.getValue());
            prop2.setError(error2);
            ++prop;
        }
        Property[] props = new Property[]{this.pEnableWeakPullUpReset, this.pEnableWeakPullUpSuspend, this.pUseSuspend};
        propertyArray = props;
        int n3 = props.length;
        n = 0;
        while (n < n3) {
            Property prop3 = propertyArray[n];
            error = !prop3.getDefaultValue().equals(prop3.getValue());
            prop3.setError(error);
            ++n;
        }
    }

    private void updateValues(CP2108PinConfig config) {
        int i = 0;
        while (i < this.grpIfc.length) {
            this.grpIfc[i].pResetMode.setValue(String.format("%02X", config.resetMode[i]));
            this.grpIfc[i].pResetLowPower.setValue(String.format("%02X", config.resetLowPower[i]));
            this.grpIfc[i].pResetValue.setValue(String.format("%02X", config.resetValue[i]));
            this.grpIfc[i].pSuspendMode.setValue(String.format("%02X", config.suspendMode[i]));
            this.grpIfc[i].pSuspendLowPower.setValue(String.format("%02X", config.suspendLowPower[i]));
            this.grpIfc[i].pSuspendValue.setValue(String.format("%02X", config.suspendValue[i]));
            this.grpIfc[i].pIPDelay.setValue(String.format("%02X", config.ipDelay[i]));
            this.grpIfc[i].pTXLEDAutoMode.setValue(String.valueOf(config.txLEDAutoMode[i]));
            this.grpIfc[i].pRXLEDAutoMode.setValue(String.valueOf(config.rxLEDAutoMode[i]));
            this.grpIfc[i].pRS485AutoMode.setValue(String.valueOf(config.rs485AutoMode[i]));
            this.grpIfc[i].pRS485Invert.setValue(String.valueOf(config.rs485Invert[i]));
            this.grpIfc[i].pGPIOClockEnable.setValue(String.valueOf(config.useClock[i]));
            this.grpIfc[i].pUseDynamicSuspend.setValue(String.valueOf(config.useSuspendValues[i]));
            this.grpIfc[i].pClockDivider.setValue(String.format("%02X", config.extClk[i]));
            ++i;
        }
        this.grpPins.pResetMode.setValue(String.format("%04X", config.resetMode[4]));
        this.grpPins.pResetLowPower.setValue(String.format("%04X", config.resetLowPower[4]));
        this.grpPins.pResetValue.setValue(String.format("%04X", config.resetValue[4]));
        this.grpPins.pSuspendMode.setValue(String.format("%04X", config.suspendMode[4]));
        this.grpPins.pSuspendLowPower.setValue(String.format("%04X", config.suspendLowPower[4]));
        this.grpPins.pSuspendValue.setValue(String.format("%04X", config.suspendValue[4]));
        this.pEnableWeakPullUpReset.setValue(String.valueOf(config.enableWeakPullUpReset));
        this.pEnableWeakPullUpSuspend.setValue(String.valueOf(config.enableWeakPullUpSuspend));
        this.pUseSuspend.setValue(String.valueOf(config.enableDynamicSuspend));
    }

    private void updateWritten(boolean written) {
        int i = 0;
        while (i < this.grpIfc.length) {
            this.grpIfc[i].pResetMode.setWritten(written);
            this.grpIfc[i].pResetLowPower.setWritten(written);
            this.grpIfc[i].pResetValue.setWritten(written);
            this.grpIfc[i].pSuspendMode.setWritten(written);
            this.grpIfc[i].pSuspendLowPower.setWritten(written);
            this.grpIfc[i].pSuspendValue.setWritten(written);
            this.grpIfc[i].pIPDelay.setWritten(written);
            this.grpIfc[i].pTXLEDAutoMode.setWritten(written);
            this.grpIfc[i].pRXLEDAutoMode.setWritten(written);
            this.grpIfc[i].pRS485AutoMode.setWritten(written);
            this.grpIfc[i].pRS485Invert.setWritten(written);
            this.grpIfc[i].pGPIOClockEnable.setWritten(written);
            this.grpIfc[i].pUseDynamicSuspend.setWritten(written);
            this.grpIfc[i].pClockDivider.setWritten(written);
            ++i;
        }
        this.grpPins.pResetMode.setWritten(written);
        this.grpPins.pResetLowPower.setWritten(written);
        this.grpPins.pResetValue.setWritten(written);
        this.grpPins.pSuspendMode.setWritten(written);
        this.grpPins.pSuspendLowPower.setWritten(written);
        this.grpPins.pSuspendValue.setWritten(written);
        this.pEnableWeakPullUpReset.setWritten(written);
        this.pEnableWeakPullUpSuspend.setWritten(written);
        this.pUseSuspend.setWritten(written);
    }

    @Override
    public void resetSiliconLabsDefaultValues() {
        int i = 0;
        while (i < this.grpIfc.length) {
            this.grpIfc[i].pResetMode.reset("15");
            this.grpIfc[i].pResetLowPower.reset("00");
            this.grpIfc[i].pResetValue.reset("FF");
            this.grpIfc[i].pSuspendMode.reset("15");
            this.grpIfc[i].pSuspendLowPower.reset("00");
            this.grpIfc[i].pSuspendValue.reset("FF");
            this.grpIfc[i].pIPDelay.reset("00");
            this.grpIfc[i].pTXLEDAutoMode.reset("0");
            this.grpIfc[i].pRXLEDAutoMode.reset("0");
            this.grpIfc[i].pRS485AutoMode.reset("0");
            this.grpIfc[i].pRS485Invert.reset("0");
            this.grpIfc[i].pGPIOClockEnable.reset("0");
            this.grpIfc[i].pUseDynamicSuspend.reset("0");
            this.grpIfc[i].pClockDivider.reset("FF");
            ++i;
        }
        this.grpPins.pResetMode.reset("0000");
        this.grpPins.pResetLowPower.reset("0000");
        this.grpPins.pResetValue.reset("FFFF");
        this.grpPins.pSuspendMode.reset("0000");
        this.grpPins.pSuspendLowPower.reset("0000");
        this.grpPins.pSuspendValue.reset("FFFF");
        this.pEnableWeakPullUpReset.reset("1");
        this.pEnableWeakPullUpSuspend.reset("1");
        this.pUseSuspend.reset("0");
    }
}

