/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.customizer.devices.cp210x;

import java.util.Arrays;

public final class CP2105PinConfig {
    public static final int expectedPinCount = 14;
    final byte[] pinConfigs;
    final int useSCISuspendValues;
    final int useECISuspendValues;
    final int suspendValue;
    final int resetValue;
    int latchControl;
    final int enableWeakPullUp;
    final int rs485Invert;
    int eciAutoMode;
    final int invertSCISuspend;
    final int invertECISuspend;

    CP2105PinConfig(byte[] pinConfigs, int suspendValue, int resetValue, int latchControl, int useSCISuspendValues, int useECISuspendValues, int enableWeakPullUp, int rs485Invert, int eciAutoMode, int invertSCISuspend, int invertECISuspend) {
        if (pinConfigs.length != 14) {
            throw new IllegalArgumentException("pinConfig.length != expectedPinCount");
        }
        this.pinConfigs = new byte[14];
        System.arraycopy(pinConfigs, 0, this.pinConfigs, 0, this.pinConfigs.length);
        this.suspendValue = suspendValue;
        this.resetValue = resetValue;
        this.latchControl = latchControl;
        this.useSCISuspendValues = useSCISuspendValues;
        this.useECISuspendValues = useECISuspendValues;
        this.enableWeakPullUp = enableWeakPullUp;
        this.eciAutoMode = eciAutoMode;
        this.rs485Invert = rs485Invert;
        this.invertSCISuspend = invertSCISuspend;
        this.invertECISuspend = invertECISuspend;
    }

    public CP2105PinConfig(byte[] portConfigStruct) {
        if (portConfigStruct.length < 9) {
            throw new IllegalArgumentException("portConfig.length != PORT_CONFIG_SIZE");
        }
        this.pinConfigs = new byte[14];
        int mode = (portConfigStruct[0] | portConfigStruct[1] << 8) & 0xFFFF;
        this.pinConfigs[0] = (byte)((1 & mode) != 0 ? 1 : 0);
        this.pinConfigs[1] = (byte)((2 & mode) != 0 ? 1 : 0);
        this.pinConfigs[2] = (byte)((4 & mode) != 0 ? 1 : 0);
        this.pinConfigs[3] = (byte)((8 & mode) != 0 ? 1 : 0);
        this.pinConfigs[4] = (byte)((0x10 & mode) != 0 ? 1 : 0);
        this.pinConfigs[5] = (byte)((0x40 & mode) != 0 ? 1 : 0);
        this.pinConfigs[6] = (byte)((0x80 & mode) != 0 ? 1 : 0);
        this.pinConfigs[7] = (byte)((0x100 & mode) != 0 ? 1 : 0);
        this.pinConfigs[8] = (byte)((0x200 & mode) != 0 ? 1 : 0);
        this.pinConfigs[9] = (byte)((0x400 & mode) != 0 ? 1 : 0);
        this.pinConfigs[10] = (byte)((0x800 & mode) != 0 ? 1 : 0);
        this.pinConfigs[11] = (byte)((0x1000 & mode) != 0 ? 1 : 0);
        this.pinConfigs[12] = (byte)((0x4000 & mode) != 0 ? 1 : 0);
        this.pinConfigs[13] = (byte)((0x8000 & mode) != 0 ? 1 : 0);
        this.resetValue = (portConfigStruct[2] & 0xFF | (portConfigStruct[3] & 0xFF) << 8) & 0xFFFF;
        this.suspendValue = (portConfigStruct[4] & 0xFF | (portConfigStruct[5] & 0xFF) << 8) & 0xFFFF;
        this.rs485Invert = (portConfigStruct[6] & 8) != 0 ? 1 : 0;
        this.invertECISuspend = (portConfigStruct[6] & 0x10) != 0 ? 1 : 0;
        this.useECISuspendValues = (portConfigStruct[6] & 0x40) != 0 ? 1 : 0;
        if ((portConfigStruct[6] & 1) != 0) {
            this.latchControl |= 0x400;
        }
        if ((portConfigStruct[6] & 2) != 0) {
            this.latchControl |= 0x800;
            this.eciAutoMode = 0;
        }
        if ((portConfigStruct[6] & 4) != 0) {
            this.latchControl |= 0x800;
            this.eciAutoMode = 1;
        }
        this.invertSCISuspend = (portConfigStruct[7] & 0x10) != 0 ? 1 : 0;
        this.useSCISuspendValues = (portConfigStruct[7] & 0x40) != 0 ? 1 : 0;
        if ((portConfigStruct[7] & 1) != 0) {
            this.latchControl |= 2;
        }
        if ((portConfigStruct[7] & 2) != 0) {
            this.latchControl |= 4;
        }
        this.enableWeakPullUp = (portConfigStruct[8] & 0x10) != 0 ? 1 : 0;
    }

    public String toString() {
        return String.format("PinConfig [pinConfig=%s, resetValue, suspendValue, useECISuspendValues=%X, useSCISuspendValues=%X, invertECISuspend=%X, invertSCISuspend=%X enableWeakPullUp=%X, rs485Invert=%X]", Arrays.toString(this.pinConfigs), this.suspendValue, this.useECISuspendValues, this.useSCISuspendValues, this.invertECISuspend, this.invertSCISuspend, this.enableWeakPullUp, this.rs485Invert);
    }

    public byte[] getConfigStruct() {
        byte[] portConfigStruct = new byte[9];
        int mode = 0;
        mode |= this.pinConfigs[0] != 0 ? 1 : 0;
        mode |= this.pinConfigs[1] != 0 ? 2 : 0;
        mode |= this.pinConfigs[2] != 0 ? 4 : 0;
        mode |= this.pinConfigs[3] != 0 ? 8 : 0;
        mode |= this.pinConfigs[4] != 0 ? 16 : 0;
        mode |= this.pinConfigs[5] != 0 ? 64 : 0;
        mode |= this.pinConfigs[6] != 0 ? 128 : 0;
        mode |= this.pinConfigs[7] != 0 ? 256 : 0;
        mode |= this.pinConfigs[8] != 0 ? 512 : 0;
        mode |= this.pinConfigs[9] != 0 ? 1024 : 0;
        mode |= this.pinConfigs[10] != 0 ? 2048 : 0;
        mode |= this.pinConfigs[11] != 0 ? 4096 : 0;
        mode |= this.pinConfigs[12] != 0 ? 16384 : 0;
        portConfigStruct[0] = (byte)((mode |= this.pinConfigs[13] != 0 ? 32768 : 0) & 0xFF);
        portConfigStruct[1] = (byte)((mode & 0xFF00) >> 8);
        portConfigStruct[2] = (byte)(this.resetValue & 0xFF);
        portConfigStruct[3] = (byte)((this.resetValue & 0xFF00) >> 8);
        portConfigStruct[4] = (byte)(this.suspendValue & 0xFF);
        portConfigStruct[5] = (byte)((this.suspendValue & 0xFF00) >> 8);
        if (this.rs485Invert > 0) {
            portConfigStruct[6] = (byte)(portConfigStruct[6] | 8);
        }
        if (this.invertECISuspend != 0) {
            portConfigStruct[6] = (byte)(portConfigStruct[6] | 0x10);
        }
        if (this.useECISuspendValues > 0) {
            portConfigStruct[6] = (byte)(portConfigStruct[6] | 0x40);
        }
        if ((this.latchControl & 0x400) != 0) {
            portConfigStruct[6] = (byte)(portConfigStruct[6] | 1);
        }
        if ((this.latchControl & 0x800) != 0) {
            portConfigStruct[6] = this.eciAutoMode != 0 ? (byte)(portConfigStruct[6] | 4) : (byte)(portConfigStruct[6] | 2);
        }
        if (this.invertSCISuspend != 0) {
            portConfigStruct[7] = (byte)(portConfigStruct[7] | 0x10);
        }
        if (this.useSCISuspendValues != 0) {
            portConfigStruct[7] = (byte)(portConfigStruct[7] | 0x40);
        }
        if ((this.latchControl & 2) != 0) {
            portConfigStruct[7] = (byte)(portConfigStruct[7] | 1);
        }
        if ((this.latchControl & 4) != 0) {
            portConfigStruct[7] = (byte)(portConfigStruct[7] | 2);
        }
        if (this.enableWeakPullUp != 0) {
            portConfigStruct[8] = (byte)(portConfigStruct[8] | 0x10);
        }
        return portConfigStruct;
    }
}

