/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.customizer.devices;

import com.silabs.customizer.Application;
import com.silabs.customizer.devices.CellEditorFactory;
import com.silabs.customizer.devices.Device;
import com.silabs.customizer.devices.IDeviceVisitor;
import com.silabs.customizer.devices.Item;
import com.silabs.customizer.devices.PropertyGroup;
import com.silabs.customizer.log.MessageLog;

public abstract class Property {
    private final Device device;
    private final PropertyGroup parent;
    private final String name;
    private final Item[] items;
    private String defaultValue;
    private String defaultValueString;
    private String value;
    private String valueString;
    private String bitMaskString;
    private int bitMaskValue;
    private boolean isError;
    private boolean isWritten;
    private boolean needsVerification;

    public Property(Device device, PropertyGroup parent, String name, Item[] items) {
        if (device == null) {
            throw new NullPointerException("device");
        }
        if (name == null) {
            throw new NullPointerException("name");
        }
        this.device = device;
        this.name = name;
        this.parent = parent;
        this.items = items;
    }

    public void initProperty() {
        try {
            this.setValue(this.readValueFromDevice());
            this.setDefaultValue(this.value);
        }
        catch (Exception exc) {
            this.isError = true;
            this.logReadFailed(this.device, exc);
        }
    }

    protected void initBitMask(int bitMaskValue, String bitMaskString) {
        this.bitMaskValue = bitMaskValue;
        this.bitMaskString = bitMaskString;
    }

    public CellEditorFactory getCellEditorFactory() {
        return null;
    }

    public String getXMLValue() {
        return null;
    }

    public String getBitMaskString() {
        return this.bitMaskString;
    }

    public int getBitMaskValue() {
        if (this.getValue() != "0") {
            return this.bitMaskValue;
        }
        return 0;
    }

    public final String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String value) {
        if (value == null) {
            throw new NullPointerException("value");
        }
        this.defaultValue = value.trim();
        if (this.getItems() == null) {
            this.setDefaultValueString(this.defaultValue);
        } else {
            this.setDefaultValueString(this.getItems()[Integer.parseInt(this.defaultValue)].getDescription());
        }
    }

    public void setRawDefaultValue(String value) {
        if (value == null) {
            throw new NullPointerException("value");
        }
        this.defaultValue = value;
    }

    public final String getDefaultValueString() {
        return this.defaultValueString;
    }

    public void setDefaultValueString(String defaultValueString) {
        this.defaultValueString = defaultValueString;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        if (value == null) {
            throw new NullPointerException("value");
        }
        String trimmedValue = value.trim();
        if (!trimmedValue.equals(this.value)) {
            this.value = trimmedValue;
            if (this.getItems() == null) {
                this.setValueString(this.value);
            } else {
                this.setValueString(this.getItems()[Integer.parseInt(this.value)].getDescription());
            }
            this.isWritten = false;
            this.isError = false;
        }
    }

    public void setRawValue(String value) {
        if (value == null) {
            throw new NullPointerException("value");
        }
        this.value = value;
    }

    public String getValueString() {
        return this.valueString;
    }

    public void setValueString(String valueString) {
        this.valueString = valueString;
    }

    public Item[] getItems() {
        return this.items;
    }

    public String getName() {
        return this.name;
    }

    public PropertyGroup getParent() {
        return this.parent;
    }

    public final boolean hasItems() {
        Item[] items = this.getItems();
        return items != null && items.length > 0;
    }

    public boolean isChanged() {
        return !this.defaultValue.equals(this.value);
    }

    public boolean isError() {
        return this.isError;
    }

    public boolean isWritten() {
        return this.isWritten;
    }

    public boolean needsVerification() {
        return this.needsVerification;
    }

    public boolean isSerial() {
        return false;
    }

    public boolean isLockValue() {
        return false;
    }

    public void program() {
        if (!this.isChanged() || this.isError()) {
            return;
        }
        if (Application.DRY_RUN) {
            this.defaultValue = this.value;
            this.isWritten = true;
            this.logWrite(this.isError, null);
        } else {
            try {
                this.writeToDevice();
                this.isWritten = true;
                this.needsVerification = true;
            }
            catch (Exception exc) {
                this.isError = true;
                this.logWrite(this.isError, exc);
            }
        }
    }

    public void verify() {
        try {
            this.needsVerification = false;
            this.defaultValue = this.readValueFromDevice();
            if (!this.value.equals(this.defaultValue)) {
                this.isError = true;
            }
            this.logWrite(this.isError, null);
        }
        catch (Exception exc) {
            this.isError = true;
            this.logWrite(this.isError, exc);
        }
    }

    public void reset() {
        this.setValue(this.getDefaultValue());
    }

    public void reset(String value) {
        this.setValue(value);
    }

    public void setError(boolean isError) {
        this.isError = isError;
    }

    public void setWritten(boolean isWritten) {
        this.isWritten = isWritten;
    }

    public void visit(IDeviceVisitor visitor) {
        visitor.accept(this);
    }

    protected final Device getDevice() {
        return this.device;
    }

    protected final void logReadFailed(Device device, Exception exc) {
        String message = String.format("%s FAILED read of %s.", device.getType(), this.getName());
        MessageLog.error(message, exc);
    }

    protected String readValueFromDevice() throws Exception {
        return "";
    }

    protected void writeToDevice() throws Exception {
    }

    private final void logWrite(boolean error, Exception exc) {
        if (!error) {
            MessageLog.info(String.format("%s Successul write of %s: %s", this.device.getType(), this.getName(), this.getValue()));
        } else {
            String message = String.format("%s FAILED write of %s: %s. Device value: %s", this.device.getType(), this.getName(), this.getValue(), this.getDefaultValue());
            MessageLog.error(message, exc);
        }
    }
}

