/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.nebula.widgets.pgroup;

import com.silabs.nebula.widgets.pgroup.PGroup;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.SWTEventListener;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public class PGroupToolItem
extends Item {
    private Rectangle bounds;
    private boolean selection;
    private Rectangle dropdownArea;
    private PGroup parent;
    private String tooltip;

    public PGroupToolItem(PGroup parent, int style) {
        super((Widget)parent, style);
        this.parent = parent;
        parent.addToolItem(this);
    }

    public void setBounds(Rectangle bounds) {
        this.bounds = bounds;
    }

    public Rectangle getBounds() {
        return this.bounds;
    }

    public void setSelection(boolean selection) {
        if ((this.getStyle() & 0x30) == 0) {
            return;
        }
        if (selection) {
            PGroupToolItem[] items = this.parent.getToolItems();
            int i = 0;
            while (i < items.length) {
                items[i].setSelection(false);
                ++i;
            }
        }
        this.selection = selection;
        this.parent.redraw();
    }

    public boolean getSelection() {
        return this.selection;
    }

    public void addSelectionListener(SelectionListener listener) {
        TypedListener typedListener = new TypedListener((SWTEventListener)listener);
        this.addListener(13, (Listener)typedListener);
        this.addListener(14, (Listener)typedListener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.removeListener(13, (SWTEventListener)listener);
        this.removeListener(14, (SWTEventListener)listener);
    }

    void setDropDownArea(Rectangle dropdownArea) {
        this.dropdownArea = dropdownArea;
    }

    void onMouseDown(Event e) {
        if ((this.getStyle() & 4) == 0) {
            this.setSelection(!this.getSelection());
            this.notifyListeners(13, new Event());
        } else if (!((this.getStyle() & 8) != 8 || this.dropdownArea != null && this.dropdownArea.contains(e.x, e.y))) {
            this.notifyListeners(13, new Event());
        } else {
            Event event = new Event();
            event.detail = 4;
            event.x = this.bounds.x;
            event.y = this.bounds.y + this.bounds.height;
            this.notifyListeners(13, event);
        }
    }

    public void setToolTipText(String tooltip) {
        this.tooltip = tooltip;
    }

    public String getToolTipText() {
        return this.tooltip;
    }
}

