/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.customizer.devices.cp261x.XMLtoHEX;

import com.silabs.customizer.devices.cp261x.XMLtoHEX.Field;
import com.silabs.customizer.devices.cp261x.XMLtoHEX.VarArray;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.Arrays;
import org.jdom2.Attribute;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;

public class CPConfigurator {
    static String commentHeader = "//-----------------------------------------------------------------------------\n// Copyright (c) 2014 by Silicon Laboratories Inc. All rights reserved.\n//\n// LICENSE_PLACEHOLDER\n//\n//------------------------------------------------------------------------------\n\n#include <stdint.h>\n#include \"compiler_defs.h\"\n\n// ==================================================\n// Auto-generated init bytes for device configuration\n";

    private static int fixedLength(Element rootNode) {
        int ret = 0;
        for (Element child : rootNode.getChildren()) {
            if (child.getName().equals("field")) {
                Field field = new Field(child);
                ret += field.length();
                continue;
            }
            if (!child.getName().equals("vararray")) continue;
            VarArray vararray = new VarArray(child);
            ret += vararray.length();
        }
        System.out.printf("Computed fixed structure length of %d (incl header)\n", ret);
        return ret;
    }

    private static int variableLength(Element rootNode) {
        int ret = 0;
        for (Element child : rootNode.getChildren()) {
            if (!child.getName().equals("vararray")) continue;
            VarArray vararray = new VarArray(child);
            ret += vararray.varLength();
        }
        System.out.printf("Computed variable structure length of %d\n", ret);
        return ret;
    }

    private static void printFileHeader(PrintStream outStream, String deviceName) {
        outStream.print(commentHeader);
        outStream.printf("// DEVICE: %s\n\n", deviceName);
    }

    private static void printLeadingComments(PrintStream outStream, Element rootNode) {
        for (Element comment : rootNode.getChildren()) {
            if (!comment.getName().equals("comment")) break;
            outStream.printf("// %s\n", comment.getText());
        }
        outStream.printf("\n", new Object[0]);
    }

    private static void printStructureOpen(PrintStream outStream, String structName) {
        outStream.printf("const uint8_t SEG_CODE %s[] =\n{\n", structName);
    }

    private static void printStructureClose(PrintStream outStream) {
        outStream.printf("};\n\n", new Object[0]);
    }

    private static void updateComputedLength(Element rootNode, int computedLength) {
        for (Element child : rootNode.getChildren()) {
            Attribute typeAttr;
            Attribute nameAttr;
            String childName = child.getName();
            if (!childName.equals("field") || !(nameAttr = child.getAttribute("name")).getValue().equals("length") || !(typeAttr = child.getAttribute("type")).getValue().equals("computed")) continue;
            Element valueNode = child.getChild("value");
            valueNode.setText("" + computedLength);
            child.setAttribute("type", "num");
            break;
        }
    }

    private static void updateComputedChecksum(Element rootNode, int checksum) {
        for (Element child : rootNode.getChildren()) {
            Attribute typeAttr;
            Attribute nameAttr;
            String childName = child.getName();
            if (!childName.equals("field") || !(nameAttr = child.getAttribute("name")).getValue().equals("checksum") || !(typeAttr = child.getAttribute("type")).getValue().equals("computed")) continue;
            Element valueNode = child.getChild("value");
            valueNode.setText("" + checksum);
            child.setAttribute("type", "num");
            break;
        }
    }

    private static short computeChecksum(byte[] binData) {
        int checksum = 0;
        int i = 0;
        while (i < binData.length) {
            checksum = (short)(checksum + (short)(binData[i] & 0xFF));
            ++i;
        }
        return (short)(checksum & 0xFFFF);
    }

    private static void fixupConfigFields(Element rootNode) {
        int fixedLength = CPConfigurator.fixedLength(rootNode);
        int headerLength = 44;
        int varLength = CPConfigurator.variableLength(rootNode);
        CPConfigurator.updateComputedLength(rootNode, (fixedLength -= headerLength) + varLength);
        ByteArrayOutputStream binStream = new ByteArrayOutputStream();
        CPConfigurator.renderBinary(binStream, rootNode);
        byte[] binData = binStream.toByteArray();
        byte[] checksumData = Arrays.copyOfRange(binData, headerLength -= 2, binStream.size());
        short checksum = CPConfigurator.computeChecksum(checksumData);
        CPConfigurator.updateComputedChecksum(rootNode, checksum);
    }

    private static void printContent(PrintStream outStream, Element rootNode) {
        int varOffset = 0;
        ByteArrayOutputStream varOutStream = new ByteArrayOutputStream();
        PrintStream varStream = new PrintStream(varOutStream);
        outStream.printf("  // --- Static fields initializers ---\n\n", new Object[0]);
        for (Element child : rootNode.getChildren()) {
            String childName = child.getName();
            if (childName.equals("field")) {
                Field field = new Field(child);
                field.renderForC(outStream);
                continue;
            }
            if (!childName.equals("vararray")) continue;
            VarArray vararray = new VarArray(child);
            varOffset += vararray.renderForC(varOffset, outStream, varStream);
        }
        outStream.printf("  // --- Variable field initializers ---\n\n", new Object[0]);
        outStream.printf(varOutStream.toString(), new Object[0]);
    }

    private static void renderBinary(ByteArrayOutputStream outStream, Element rootNode) {
        int varOffset = 0;
        ByteArrayOutputStream varStream = new ByteArrayOutputStream();
        for (Element child : rootNode.getChildren()) {
            String childName = child.getName();
            if (childName.equals("field")) {
                Field field = new Field(child);
                field.renderForBin(outStream);
                continue;
            }
            if (!childName.equals("vararray")) continue;
            VarArray vararray = new VarArray(child);
            varOffset += vararray.renderForBin(varOffset, outStream, varStream);
        }
        try {
            outStream.write(varStream.toByteArray());
        }
        catch (IOException iOException) {
            System.out.println("Error writing var data to output file");
        }
    }

    private static void renderHex(byte[] binData, PrintStream hexStream, int address) {
        byte checksum = 0;
        int byteCount = 0;
        int i = 0;
        while (i < binData.length) {
            if (i % 16 == 0) {
                checksum = 0;
                byteCount = binData.length - i > 16 ? 16 : binData.length - i;
                hexStream.printf(":%02X%02X%02X00", byteCount, address >> 8 & 0xFF, address & 0xFF);
                checksum = (byte)(checksum + byteCount);
                checksum = (byte)(checksum + (address >> 8 & 0xFF));
                checksum = (byte)(checksum + (address & 0xFF));
            }
            hexStream.printf("%02X", binData[i]);
            checksum = (byte)(checksum + binData[i]);
            if (i % 16 == byteCount - 1) {
                checksum = -checksum;
                hexStream.printf("%02X\n", checksum & 0xFF);
                address += byteCount;
            }
            ++i;
        }
        hexStream.printf(":00000001FF\n", new Object[0]);
    }

    private static String renderHexString(byte[] binData, int address) {
        String hexString = "";
        byte checksum = 0;
        int byteCount = 0;
        int currentAddress = address;
        int i = 0;
        while (i < binData.length) {
            if (i % 16 == 0) {
                checksum = 0;
                byteCount = binData.length - i > 16 ? 16 : binData.length - i;
                hexString = String.valueOf(hexString) + String.format(":%02X%02X%02X00", byteCount, currentAddress >> 8 & 0xFF, currentAddress & 0xFF);
                checksum = (byte)(checksum + byteCount);
                checksum = (byte)(checksum + (currentAddress >> 8 & 0xFF));
                checksum = (byte)(checksum + (currentAddress & 0xFF));
            }
            hexString = String.valueOf(hexString) + String.format("%02X", binData[i]);
            checksum = (byte)(checksum + binData[i]);
            if (i % 16 == byteCount - 1) {
                checksum = -checksum;
                hexString = String.valueOf(hexString) + String.format("%02X\n", checksum & 0xFF);
                currentAddress += byteCount;
            }
            ++i;
        }
        hexString = String.valueOf(hexString) + String.format(":00000001FF\n", new Object[0]);
        return hexString;
    }

    public static String generateHexString(String xmlFileInput) {
        SAXBuilder jdomBuilder = new SAXBuilder();
        Document jdomDocument = new Document();
        try {
            jdomDocument = jdomBuilder.build((Reader)new StringReader(xmlFileInput));
        }
        catch (JDOMException e) {
            e.printStackTrace();
            return null;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        Element rootNode = jdomDocument.getRootElement();
        if (!rootNode.getName().equals("config")) {
            return null;
        }
        Attribute deviceAttr = rootNode.getAttribute("device");
        if (deviceAttr == null) {
            return null;
        }
        CPConfigurator.fixupConfigFields(rootNode);
        Attribute outfileAttr = rootNode.getAttribute("outfile");
        if (outfileAttr == null) {
            return null;
        }
        ByteArrayOutputStream binStream = new ByteArrayOutputStream();
        CPConfigurator.renderBinary(binStream, rootNode);
        int address = 0;
        Attribute addressAttr = rootNode.getAttribute("address");
        if (addressAttr != null) {
            address = Integer.decode(addressAttr.getValue());
        }
        CPConfigurator.renderHexString(binStream.toByteArray(), address);
        String relativeHexString = CPConfigurator.renderHexString(binStream.toByteArray(), 0);
        return relativeHexString;
    }
}

