/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.customizer.devices.cp261x;

import com.silabs.customizer.devices.Device;
import com.silabs.customizer.devices.Item;
import com.silabs.customizer.devices.Property;
import java.util.Locale;

public class PropertyEAIOProtocolEnable
extends Property {
    public PropertyEAIOProtocolEnable(Device device) {
        super(device, null, "Enable EA I/O Protocol", new Item[]{new Item("0", String.format("No", new Object[0])), new Item("1", String.format("Yes", new Object[0]))});
        this.initBitMask(16, "CFG_FLAG_ENABLE_EAPROTO_IO");
        this.initProperty();
    }

    @Override
    public void setDefaultValue(String value) {
        super.setDefaultValue(value.toUpperCase(Locale.ENGLISH));
    }

    @Override
    public void setValue(String value) {
        try {
            super.setValue(value);
        }
        catch (NumberFormatException numberFormatException) {}
    }

    @Override
    protected String readValueFromDevice() throws Exception {
        return "1";
    }

    public String getMessagesReceivedXML() {
        String xmlValueString = "";
        if (this.getValue() == "1") {
            xmlValueString = String.valueOf(xmlValueString) + "      <field name=\"msgStartEaProtocol\" type=\"hex\" size=\"2\" order=\"be\">\n";
            xmlValueString = String.valueOf(xmlValueString) + "        <value>0xEA00</value>\n";
            xmlValueString = String.valueOf(xmlValueString) + "      </field>\n";
            xmlValueString = String.valueOf(xmlValueString) + "      <field name=\"msgStopEaProtocol\" type=\"hex\" size=\"2\" order=\"be\">\n";
            xmlValueString = String.valueOf(xmlValueString) + "        <value>0xEA01</value>\n";
            xmlValueString = String.valueOf(xmlValueString) + "      </field>";
        }
        return xmlValueString;
    }

    public String getEaIoProtocolXML(String protocolString) {
        String xmlValueString = "";
        if (this.getValue() == "1") {
            xmlValueString = String.valueOf(xmlValueString) + "    <parametergroup name=\"eaProtocolGroup\" id=\"10\">\n";
            xmlValueString = String.valueOf(xmlValueString) + "      <comment>IO Protocol definition</comment>\n";
            xmlValueString = String.valueOf(xmlValueString) + "      <parameter name=\"eaProtocolIdParm\" id=\"0\">\n";
            xmlValueString = String.valueOf(xmlValueString) + "        <comment>IO protocol ID is 1</comment>\n";
            xmlValueString = String.valueOf(xmlValueString) + "        <field name=\"eaProtocolId\" type=\"num\" size=\"1\"><value>1</value></field>\n";
            xmlValueString = String.valueOf(xmlValueString) + "      </parameter>\n";
            xmlValueString = String.valueOf(xmlValueString) + "      <parameter name=\"eaProtocolNameParm\" id=\"1\">\n";
            xmlValueString = String.valueOf(xmlValueString) + "        <field name=\"eaProtocolNameUtf8\" type=\"utf8\">\n";
            xmlValueString = String.valueOf(xmlValueString) + "          <value>";
            xmlValueString = String.valueOf(xmlValueString) + protocolString;
            xmlValueString = String.valueOf(xmlValueString) + "</value>\n";
            xmlValueString = String.valueOf(xmlValueString) + "        </field>\n";
            xmlValueString = String.valueOf(xmlValueString) + "      </parameter>\n";
            xmlValueString = String.valueOf(xmlValueString) + "      <parameter name=\"eaProtocolMatchParm\" id=\"2\">\n";
            xmlValueString = String.valueOf(xmlValueString) + "        <comment>match action is none</comment>\n";
            xmlValueString = String.valueOf(xmlValueString) + "        <field name=\"eaProtocolMatchAction\" type=\"num\" size=\"1\"><value>0</value></field>\n";
            xmlValueString = String.valueOf(xmlValueString) + "      </parameter>\n";
            xmlValueString = String.valueOf(xmlValueString) + "    </parametergroup>";
        }
        return xmlValueString;
    }
}

