/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.customizer.devices.cp213x;

import com.silabs.customizer.devices.Device;
import com.silabs.customizer.devices.DeviceDetector;
import com.silabs.customizer.devices.Property;
import com.silabs.customizer.devices.cp210x.CP210xBaudConfig;
import com.silabs.customizer.devices.cp213x.Device2130;
import com.silabs.customizer.devices.cp213x.SLAB_USB_SPI;
import com.silabs.customizer.log.MessageLog;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.ByteByReference;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.PointerByReference;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;

public abstract class Device213x
extends Device {
    public static final MessageLog LOG = new MessageLog();
    private String serial;
    private String name;

    static {
        LOG.logDebug("CP213x Library Version    :", Device213x.getLibraryVersion());
    }

    public static synchronized List<Device> getDevices() {
        Device213x.checkDeviceDetection();
        LinkedList<Device> result = new LinkedList<Device>();
        int numDevices = Device213x.getNumDevices();
        int i = 0;
        while (i < numDevices) {
            try {
                String serial = Device213x.getSerial(i);
                PartNumber part = Device213x.getPartNumber(i);
                if (part.number == 30) {
                    result.add(new Device2130(serial));
                }
            }
            catch (Exception exception) {}
            ++i;
        }
        return result;
    }

    @Override
    protected Property[] createPortConfigs() {
        Property[] result = new Property[]{};
        return result;
    }

    @Override
    protected Property[] createBaudConfigs() {
        Property[] result = new Property[]{};
        return result;
    }

    @Override
    public final synchronized String getTransferPriority(Device deviceObj) throws Exception {
        Device213x.checkDeviceDetection();
        Pointer device = Device213x.openDevice((Device213x)deviceObj);
        IntByReference vid = new IntByReference();
        IntByReference pid = new IntByReference();
        ByteByReference power = new ByteByReference();
        ByteByReference powerMode = new ByteByReference();
        IntByReference releaseVersion = new IntByReference();
        ByteByReference transferPriority = new ByteByReference();
        int status = SLAB_USB_SPI.DLL.CP213x_GetUsbConfig(device, vid, pid, power, powerMode, releaseVersion, transferPriority);
        Device213x.close(device);
        String result = status == 0 ? Device213x.toHexString(transferPriority.getValue(), 2) : "";
        LOG.logDebug(status, "getTransferPriority:", result);
        if (status != 0) {
            throw new Exception("getTransferPriority(" + deviceObj + "): " + status);
        }
        return result;
    }

    @Override
    public final synchronized String getManufacturer(Device deviceObj) throws Exception {
        Device213x.checkDeviceDetection();
        Pointer device = Device213x.openDevice((Device213x)deviceObj);
        byte[] manufacturingString = new byte[62];
        ByteByReference strlen = new ByteByReference();
        int status = SLAB_USB_SPI.DLL.CP213x_GetManufacturingString(device, manufacturingString, strlen);
        Device213x.close(device);
        String result = status == 0 ? Native.toString((byte[])manufacturingString) : "";
        LOG.logDebug(status, "getManufacturer:", result);
        if (status != 0) {
            throw new Exception("getManufacturer(" + deviceObj + "): " + status);
        }
        return result;
    }

    @Override
    public final synchronized String getPID(Device deviceObj) throws Exception {
        Device213x.checkDeviceDetection();
        Pointer device = Device213x.openDevice((Device213x)deviceObj);
        IntByReference vid = new IntByReference();
        IntByReference pid = new IntByReference();
        ByteByReference power = new ByteByReference();
        ByteByReference powerMode = new ByteByReference();
        IntByReference releaseVersion = new IntByReference();
        ByteByReference transferPriority = new ByteByReference();
        int status = SLAB_USB_SPI.DLL.CP213x_GetUsbConfig(device, vid, pid, power, powerMode, releaseVersion, transferPriority);
        Device213x.close(device);
        String result = status == 0 ? Device213x.toHexString(pid.getValue(), 4) : "";
        LOG.logDebug(status, "getPID:", result);
        if (status != 0) {
            throw new Exception("getPID(" + deviceObj + "): " + status);
        }
        return result;
    }

    @Override
    public final synchronized String getPower(Device deviceObj) throws Exception {
        Device213x.checkDeviceDetection();
        Pointer device = Device213x.openDevice((Device213x)deviceObj);
        IntByReference vid = new IntByReference();
        IntByReference pid = new IntByReference();
        ByteByReference power = new ByteByReference();
        ByteByReference powerMode = new ByteByReference();
        IntByReference releaseVersion = new IntByReference();
        ByteByReference transferPriority = new ByteByReference();
        int status = SLAB_USB_SPI.DLL.CP213x_GetUsbConfig(device, vid, pid, power, powerMode, releaseVersion, transferPriority);
        Device213x.close(device);
        String result = status == 0 ? Device213x.toHexString(power.getValue(), 2) : "";
        LOG.logDebug(status, "getPower:", result);
        if (status != 0) {
            throw new Exception("getPower(" + deviceObj + "): " + status);
        }
        return result;
    }

    @Override
    public final synchronized String getPowerMode(Device deviceObj) throws Exception {
        Device213x.checkDeviceDetection();
        Pointer device = Device213x.openDevice((Device213x)deviceObj);
        IntByReference vid = new IntByReference();
        IntByReference pid = new IntByReference();
        ByteByReference power = new ByteByReference();
        ByteByReference powerMode = new ByteByReference();
        IntByReference releaseVersion = new IntByReference();
        ByteByReference transferPriority = new ByteByReference();
        int status = SLAB_USB_SPI.DLL.CP213x_GetUsbConfig(device, vid, pid, power, powerMode, releaseVersion, transferPriority);
        Device213x.close(device);
        String result = status == 0 ? Device213x.toHexString(powerMode.getValue(), 2) : "";
        LOG.logDebug(status, "getPowerMode:", result);
        if (status != 0) {
            throw new Exception("getPowerMode(" + deviceObj + "): " + status);
        }
        return result;
    }

    @Override
    public final synchronized String getProduct(Device deviceObj) throws Exception {
        Device213x.checkDeviceDetection();
        Pointer device = Device213x.openDevice((Device213x)deviceObj);
        byte[] productString = new byte[62];
        ByteByReference strlen = new ByteByReference();
        int status = SLAB_USB_SPI.DLL.CP213x_GetProductString(device, productString, strlen);
        Device213x.close(device);
        String result = status == 0 ? Native.toString((byte[])productString) : "";
        LOG.logDebug(status, "getProduct:", result);
        if (status != 0) {
            throw new Exception("getProduct(" + deviceObj + "): " + status);
        }
        return result;
    }

    @Override
    public final synchronized String getReleaseVersion(Device deviceObj) throws Exception {
        Device213x.checkDeviceDetection();
        Pointer device = Device213x.openDevice((Device213x)deviceObj);
        IntByReference vid = new IntByReference();
        IntByReference pid = new IntByReference();
        ByteByReference power = new ByteByReference();
        ByteByReference powerMode = new ByteByReference();
        IntByReference releaseVersion = new IntByReference();
        ByteByReference transferPriority = new ByteByReference();
        int status = SLAB_USB_SPI.DLL.CP213x_GetUsbConfig(device, vid, pid, power, powerMode, releaseVersion, transferPriority);
        Device213x.close(device);
        String result = "";
        if (status == 0) {
            result = Device213x.toHexString(releaseVersion.getValue(), 4);
        }
        LOG.logDebug(status, "getRelease:", result);
        if (status != 0) {
            throw new Exception("getRelease(" + deviceObj + "): " + status);
        }
        return result;
    }

    @Override
    public final synchronized String getSerial(Device deviceObj) throws Exception {
        Device213x.checkDeviceDetection();
        Pointer device = Device213x.openDevice((Device213x)deviceObj);
        byte[] serialString = new byte[30];
        ByteByReference strlen = new ByteByReference();
        int status = SLAB_USB_SPI.DLL.CP213x_GetSerialString(device, serialString, strlen);
        Device213x.close(device);
        String result = status == 0 ? Native.toString((byte[])serialString) : "";
        LOG.logDebug(status, "getSerial:", result);
        if (status != 0) {
            throw new Exception("getSerial(" + deviceObj + "): " + status);
        }
        return result;
    }

    @Override
    public final synchronized String getVID(Device deviceObj) throws Exception {
        Device213x.checkDeviceDetection();
        Pointer device = Device213x.openDevice((Device213x)deviceObj);
        IntByReference vid = new IntByReference();
        IntByReference pid = new IntByReference();
        ByteByReference power = new ByteByReference();
        ByteByReference powerMode = new ByteByReference();
        IntByReference releaseVersion = new IntByReference();
        ByteByReference transferPriority = new ByteByReference();
        int status = SLAB_USB_SPI.DLL.CP213x_GetUsbConfig(device, vid, pid, power, powerMode, releaseVersion, transferPriority);
        Device213x.close(device);
        String result = status == 0 ? Device213x.toHexString(vid.getValue(), 4) : "";
        LOG.logDebug(status, "getVID:", result);
        if (status != 0) {
            throw new Exception("getVID(" + deviceObj + "): " + status);
        }
        return result;
    }

    @Override
    public final synchronized void setManufacturer(Device deviceObj, String manufacturer) throws Exception {
        Device213x.checkDeviceDetection();
        Pointer device = Device213x.openDevice((Device213x)deviceObj);
        byte[] manuStr = Native.toByteArray((String)manufacturer);
        int status = 81;
        if (manuStr.length < 127) {
            byte strlen = (byte)manuStr.length;
            status = SLAB_USB_SPI.DLL.CP213x_SetManufacturingString(device, manuStr, strlen);
        }
        Device213x.close(device);
        LOG.logDebug(status, "setManufacturer:", Arrays.toString(manuStr));
        if (status != 0) {
            throw new Exception("setManufacturer(" + deviceObj + "): " + status);
        }
    }

    @Override
    public final synchronized void setProduct(Device deviceObj, String product) throws Exception {
        Device213x.checkDeviceDetection();
        Pointer device = Device213x.openDevice((Device213x)deviceObj);
        byte[] prodStr = Native.toByteArray((String)product);
        int status = 81;
        if (prodStr.length < 127) {
            byte strlen = (byte)prodStr.length;
            status = SLAB_USB_SPI.DLL.CP213x_SetProductString(device, prodStr, strlen);
        }
        Device213x.close(device);
        LOG.logDebug(status, "setProduct:", Arrays.toString(prodStr));
        if (status != 0) {
            throw new Exception("setProduct(" + deviceObj + "): " + status);
        }
    }

    @Override
    public final synchronized void setSerial(Device deviceObj, String serial) throws Exception {
        Device213x.checkDeviceDetection();
        Pointer device = Device213x.openDevice((Device213x)deviceObj);
        byte[] serialStr = Native.toByteArray((String)serial);
        int status = 81;
        if (serialStr.length < 127) {
            byte strlen = (byte)serialStr.length;
            status = SLAB_USB_SPI.DLL.CP213x_SetSerialString(device, serialStr, strlen);
        }
        Device213x.close(device);
        LOG.logDebug(status, "setSerial:", Arrays.toString(serialStr));
        if (status != 0) {
            throw new Exception("setSerial(" + deviceObj + "): " + status);
        }
    }

    @Override
    public final synchronized void setTransferPriority(Device deviceObj, String value) throws Exception {
        Device213x.checkDeviceDetection();
        Pointer device = Device213x.openDevice((Device213x)deviceObj);
        int vid = 0;
        int pid = 0;
        byte power = 0;
        byte powerMode = 0;
        int releaseVersion = 0;
        byte transferPriority = Byte.parseByte(value, 16);
        int status = SLAB_USB_SPI.DLL.CP213x_SetUsbConfig(device, vid, pid, power, powerMode, releaseVersion, transferPriority, (byte)-128);
        Device213x.close(device);
        LOG.logDebug(status, "setTransferPriority:", value);
        if (status != 0) {
            throw new Exception("setTransferPriority(" + deviceObj + "): " + status);
        }
    }

    @Override
    public final synchronized void setReleaseVersion(Device deviceObj, String value) throws Exception {
        Device213x.checkDeviceDetection();
        Pointer device = Device213x.openDevice((Device213x)deviceObj);
        int vid = 0;
        int pid = 0;
        byte power = 0;
        byte powerMode = 0;
        int releaseVersion = Integer.parseInt(value, 16);
        byte transferPriority = 0;
        int status = SLAB_USB_SPI.DLL.CP213x_SetUsbConfig(device, vid, pid, power, powerMode, releaseVersion, transferPriority, (byte)16);
        Device213x.close(device);
        LOG.logDebug(status, "setReleaseVersion:", value);
        if (status != 0) {
            throw new Exception("setReleaseVersion(" + deviceObj + "): " + status);
        }
    }

    @Override
    public final synchronized void setPID(Device deviceObj, String value) throws Exception {
        Device213x.checkDeviceDetection();
        Pointer device = Device213x.openDevice((Device213x)deviceObj);
        int vid = 0;
        int pid = Integer.parseInt(value, 16);
        byte power = 0;
        byte powerMode = 0;
        int releaseVersion = 0;
        byte transferPriority = 0;
        int status = SLAB_USB_SPI.DLL.CP213x_SetUsbConfig(device, vid, pid, power, powerMode, releaseVersion, transferPriority, (byte)2);
        Device213x.close(device);
        LOG.logDebug(status, "setPID:", value);
        if (status != 0) {
            throw new Exception("setPID(" + deviceObj + "): " + status);
        }
    }

    @Override
    public final synchronized void setVID(Device deviceObj, String value) throws Exception {
        Device213x.checkDeviceDetection();
        Pointer device = Device213x.openDevice((Device213x)deviceObj);
        int vid = Integer.parseInt(value, 16);
        int pid = 0;
        byte power = 0;
        byte powerMode = 0;
        int releaseVersion = 0;
        byte transferPriority = 0;
        int status = SLAB_USB_SPI.DLL.CP213x_SetUsbConfig(device, vid, pid, power, powerMode, releaseVersion, transferPriority, (byte)1);
        Device213x.close(device);
        LOG.logDebug(status, "setVID:", value);
        if (status != 0) {
            throw new Exception("setVID(" + deviceObj + "): " + status);
        }
    }

    @Override
    public final synchronized void setPower(Device deviceObj, String value) throws Exception {
        Device213x.checkDeviceDetection();
        Pointer device = Device213x.openDevice((Device213x)deviceObj);
        int vid = 0;
        int pid = 0;
        byte power = Byte.parseByte(value, 16);
        byte powerMode = 0;
        int releaseVersion = 0;
        byte transferPriority = 0;
        int status = SLAB_USB_SPI.DLL.CP213x_SetUsbConfig(device, vid, pid, power, powerMode, releaseVersion, transferPriority, (byte)4);
        Device213x.close(device);
        LOG.logDebug(status, "setPower:", value);
        if (status != 0) {
            throw new Exception("setPower(" + deviceObj + "): " + status);
        }
    }

    @Override
    public final synchronized void setPowerMode(Device deviceObj, String value) throws Exception {
        Device213x.checkDeviceDetection();
        Pointer device = Device213x.openDevice((Device213x)deviceObj);
        int vid = 0;
        int pid = 0;
        byte power = 0;
        byte powerMode = Byte.parseByte(value, 16);
        int releaseVersion = 0;
        byte transferPriority = 0;
        int status = SLAB_USB_SPI.DLL.CP213x_SetUsbConfig(device, vid, pid, power, powerMode, releaseVersion, transferPriority, (byte)8);
        Device213x.close(device);
        LOG.logDebug(status, "setPowerMode:", value);
        if (status != 0) {
            throw new Exception("setPowerMode(" + deviceObj + "): " + status);
        }
    }

    protected static synchronized void checkDeviceDetection() {
        if (!DeviceDetector.getDefault().isStopped()) {
            new IllegalStateException("Device detection still active");
        }
    }

    protected static synchronized void close(Pointer device) {
        if (device != null) {
            SLAB_USB_SPI.DLL.CP213x_Close(device);
        }
    }

    private static synchronized Object getLibraryVersion() {
        String result = "";
        IntByReference major = new IntByReference();
        IntByReference minor = new IntByReference();
        IntByReference release = new IntByReference();
        int status = SLAB_USB_SPI.DLL.CP213x_GetLibraryVersion(major, minor, release);
        if (status == 0) {
            String strRelease = release.getValue() > 0 ? "release" : "debug";
            result = String.format("%d.%d-%s", major.getValue(), minor.getValue(), strRelease);
        }
        return result;
    }

    private static synchronized int getNumDevices() {
        IntByReference numDevices = new IntByReference();
        int status = SLAB_USB_SPI.DLL.CP213x_GetNumDevices(numDevices);
        if (status != 0) {
            numDevices.setValue(0);
        }
        return numDevices.getValue();
    }

    private static synchronized PartNumber getPartNumber(int deviceNum) throws Exception {
        IntByReference partNumber = new IntByReference();
        IntByReference version = new IntByReference();
        int status = 0;
        partNumber.setValue(30);
        if (status != 0) {
            throw new Exception("getPartNumber(" + deviceNum + "): " + status);
        }
        return new PartNumber(partNumber.getValue(), version.getValue());
    }

    private static synchronized String getSerial(int deviceNum) throws Exception {
        byte[] deviceString = new byte[30];
        ByteByReference deviceStringLength = new ByteByReference();
        Pointer device = Device213x.open(deviceNum);
        int status = -1;
        String result = "";
        if (device != null) {
            status = SLAB_USB_SPI.DLL.CP213x_GetSerialString(device, deviceString, deviceStringLength);
            int i = deviceStringLength.getValue();
            while (i < 30) {
                deviceString[i] = 0;
                ++i;
            }
            result = status == 0 ? Native.toString((byte[])deviceString) : "";
            Device213x.close(device);
        }
        if (status != 0) {
            throw new Exception("getSerial(" + deviceNum + "): " + status);
        }
        return result;
    }

    private static synchronized Pointer open(int deviceNum) throws Exception {
        PointerByReference devicePtr = new PointerByReference();
        int status = SLAB_USB_SPI.DLL.CP213x_OpenByIndex(deviceNum, devicePtr);
        if (status != 0) {
            throw new Exception("open(" + deviceNum + "): " + status);
        }
        return devicePtr.getValue();
    }

    protected static synchronized Pointer openDevice(Device213x device) throws Exception {
        Pointer result = null;
        int numDevices = Device213x.getNumDevices();
        int i = 0;
        while (i < numDevices && result == null) {
            try {
                String serial = Device213x.getSerial(i);
                if (device.getSerial().equals(serial)) {
                    result = Device213x.open(i);
                }
            }
            catch (Exception exception) {}
            ++i;
        }
        if (result == null) {
            throw new Exception("Device not found: " + device);
        }
        return result;
    }

    @Override
    public void resetDevice() throws Exception {
        Device213x.checkDeviceDetection();
        Pointer device = Device213x.openDevice(this);
        int status = SLAB_USB_SPI.DLL.CP213x_Reset(device);
        Device213x.close(device);
        String result = status == 0 || status == 48 ? "Success" : "Failed";
        LOG.logDebug(status, "resetDevice:", result);
        if (status != 0 && status != 48) {
            throw new Exception("resetDevice(" + this + "): " + status);
        }
        DeviceDetector.getDefault().startWaitForReset();
        int timeoutMilliseconds = 20000;
        while (DeviceDetector.getDefault().isWaitingForReset() && timeoutMilliseconds > 0) {
            Thread.sleep(100L);
            DeviceDetector.getDefault().start();
            timeoutMilliseconds -= 100;
        }
        if (DeviceDetector.getDefault().isWaitingForReset()) {
            DeviceDetector.getDefault().cancelWaitForReset();
            throw new Exception("resetDevice(" + this + "): - Device never came back from reset");
        }
    }

    @Override
    public String getInterfaceString(Device device, int interfaceNumber) throws Exception {
        return null;
    }

    @Override
    public void setInterfaceString(Device device, int interfaceNumber, String value) throws Exception {
    }

    @Override
    public String getDeviceMode(Device device) throws Exception {
        return null;
    }

    @Override
    public void setDeviceMode(Device device, String value) throws Exception {
    }

    @Override
    public String getDeviceString() {
        return this.getName();
    }

    @Override
    public void setBaudConfig(Device deviceObj, CP210xBaudConfig writeConfig) throws Exception {
    }

    @Override
    public CP210xBaudConfig getBaudConfig(Device deviceObj) throws Exception {
        return null;
    }

    @Override
    public void setFlushBuffers(Device deviceObj, String value) throws Exception {
    }

    @Override
    public String getFlushBuffers(Device deviceObj) throws Exception {
        return null;
    }

    protected static String toHexString(int value, int digits) {
        String result = String.format("%X", value);
        int diff = digits - result.length();
        while (diff > 0) {
            result = "0" + result;
            --diff;
        }
        return result;
    }

    protected Device213x(String serial) {
        this.setSerial(serial);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getSerial() {
        return this.serial;
    }

    @Override
    public void setSerial(String serial) {
        if (serial == null) {
            throw new NullPointerException("serial");
        }
        this.serial = serial;
        this.name = String.valueOf(this.getType()) + " - " + serial;
    }

    private static final class PartNumber {
        private final int number;
        private final int version;

        public PartNumber(int number, int version) {
            this.number = number;
            this.version = version;
        }
    }
}

