/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.customizer.devices.cp211x;

import java.util.Arrays;

public final class CP2110PinConfig {
    public static final int expectedPinCount = 13;
    final byte[] pinConfigs;
    final int useSuspendValues;
    final int suspendValue;
    final int suspendMode;
    final byte rs485level;
    final short clkDiv;

    CP2110PinConfig(byte[] pinConfigs, int useSuspendValues, int suspendValue, int suspendMode, byte rs485level, short clkDiv) {
        if (pinConfigs.length != 13) {
            throw new IllegalArgumentException("pinConfig.length != expectedPinCount");
        }
        this.pinConfigs = new byte[13];
        System.arraycopy(pinConfigs, 0, this.pinConfigs, 0, this.pinConfigs.length);
        this.useSuspendValues = useSuspendValues;
        this.suspendValue = suspendValue;
        this.suspendMode = suspendMode;
        this.rs485level = rs485level;
        this.clkDiv = clkDiv;
    }

    public String toString() {
        return String.format("PinConfig [pinConfig=%s, useSuspendValues=%X, suspendValue=%04X, suspendMode=%04X, rs485level=%02X, clkDiv=%02X]", Arrays.toString(this.pinConfigs), this.useSuspendValues, this.suspendValue, this.suspendMode, this.rs485level, this.clkDiv);
    }

    public boolean useSupendValues() {
        return this.useSuspendValues != 0;
    }
}

