/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.customizer.devices.cp210x;

import com.silabs.customizer.devices.Device;
import com.silabs.customizer.devices.DeviceDetector;
import com.silabs.customizer.devices.Property;
import com.silabs.customizer.devices.PropertyDeviceMode;
import com.silabs.customizer.devices.PropertyFlushBuffers;
import com.silabs.customizer.devices.PropertyInterfaceString;
import com.silabs.customizer.devices.PropertyLockValue;
import com.silabs.customizer.devices.PropertyPID;
import com.silabs.customizer.devices.PropertyPower;
import com.silabs.customizer.devices.PropertyPowerMode;
import com.silabs.customizer.devices.PropertyProductDescr;
import com.silabs.customizer.devices.PropertyReleaseVer;
import com.silabs.customizer.devices.PropertySerial;
import com.silabs.customizer.devices.PropertyVID;
import com.silabs.customizer.devices.cp210x.CP2105GroupPortConfigRoot;
import com.silabs.customizer.devices.cp210x.CP2105PinConfig;
import com.silabs.customizer.devices.cp210x.CP210xManufacturing;
import com.silabs.customizer.devices.cp210x.Device210x;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.ByteByReference;
import com.sun.jna.ptr.IntByReference;
import java.util.Arrays;

final class Device2105
extends Device210x {
    Device2105(String serial, String deviceString) {
        super(serial, deviceString);
        this.maxProductStrlen = 47;
        maxSerialStrlen = 16;
        this.maxInterfaceStrlen = 32;
        this.setOTP(true);
        this.setShowConfigureIds(true);
        this.setShowConfigureBaudRate(false);
        this.setShowConfigurePins(true);
    }

    @Override
    public String getType() {
        return "CP2105";
    }

    @Override
    protected synchronized Property[] createIds() {
        DeviceDetector.getDefault().stop();
        Property[] result = new Property[]{new PropertyVID(this), new PropertyPID(this), new PropertyPower(this), new PropertyPowerMode(this), new PropertyReleaseVer(this), new PropertyFlushBuffers(this, 2), new PropertyProductDescr(this), new PropertyInterfaceString(this, 0), new PropertyInterfaceString(this, 1), new PropertySerial(this, maxSerialStrlen), new PropertyDeviceMode(this, "SCI/ECI Mode"), new PropertyLockValue(this)};
        DeviceDetector.getDefault().start();
        return result;
    }

    public static synchronized void setPinConfig(Device deviceObj, CP2105PinConfig writeConfig) throws Exception {
        Device2105.checkDeviceDetection();
        if (writeConfig.pinConfigs.length != 14) {
            throw new IllegalStateException("Error in number of configurable pins!");
        }
        Pointer device = Device2105.openDevice((Device210x)deviceObj);
        int status = CP210xManufacturing.DLL.CP210x_SetDualPortConfig(device, writeConfig.getConfigStruct());
        Device2105.close(device);
        LOG.logDebug(status, "setPinConfig", writeConfig);
        if (status != 0) {
            throw new Exception("setPinconfig(" + deviceObj + "): " + status);
        }
    }

    protected static synchronized CP2105PinConfig getPinConfig(Device deviceObj) throws Exception {
        Device2105.checkDeviceDetection();
        Pointer device = Device2105.openDevice((Device210x)deviceObj);
        byte[] portConfig = new byte[9];
        int status = CP210xManufacturing.DLL.CP210x_GetDualPortConfig(device, portConfig);
        Device2105.close(device);
        CP2105PinConfig result = new CP2105PinConfig(portConfig);
        LOG.logDebug(status, "getPinConfig", result);
        if (status != 0) {
            throw new Exception("getPinConfig(" + deviceObj + "): " + status);
        }
        return result;
    }

    @Override
    protected synchronized Property[] createPortConfigs() {
        DeviceDetector.getDefault().stop();
        Property[] result = new Property[]{new CP2105GroupPortConfigRoot(this)};
        DeviceDetector.getDefault().start();
        return result;
    }

    @Override
    public String getInterfaceString(Device deviceObj, int interfaceNumber) throws Exception {
        Device2105.checkDeviceDetection();
        Pointer device = Device2105.openDevice((Device210x)deviceObj);
        byte[] interfaceString = new byte[this.maxInterfaceStrlen];
        ByteByReference strlen = new ByteByReference();
        int status = CP210xManufacturing.DLL.CP210x_GetDeviceInterfaceString(device, (byte)interfaceNumber, interfaceString, strlen, true);
        Device2105.close(device);
        interfaceString[strlen.getValue()] = 0;
        String result = status == 0 ? Native.toString((byte[])interfaceString) : "";
        LOG.logDebug(status, "getProduct:", result);
        if (status != 0) {
            throw new Exception("getProduct(" + deviceObj + "): " + status);
        }
        return result;
    }

    @Override
    public void setInterfaceString(Device deviceObj, int interfaceNumber, String interfaceString) throws Exception {
        Device2105.checkDeviceDetection();
        Pointer device = Device2105.openDevice((Device210x)deviceObj);
        byte[] ifcStr = Native.toByteArray((String)interfaceString);
        int status = 2;
        if (ifcStr.length < this.maxInterfaceStrlen) {
            byte strlen = (byte)ifcStr.length;
            status = CP210xManufacturing.DLL.CP210x_SetInterfaceString(device, (byte)interfaceNumber, ifcStr, strlen, true);
        }
        Device2105.close(device);
        LOG.logDebug(status, "setProduct:", Arrays.toString(ifcStr));
        if (status != 0) {
            throw new Exception("setProduct(" + deviceObj + "): " + status);
        }
    }

    @Override
    public String getFlushBuffers(Device deviceObj) throws Exception {
        Device2105.checkDeviceDetection();
        Pointer device = Device2105.openDevice((Device210x)deviceObj);
        IntByReference flushBuffers = new IntByReference();
        int status = CP210xManufacturing.DLL.CP210x_GetFlushBufferConfig(device, flushBuffers);
        Device2105.close(device);
        String result = status == 0 ? Device2105.toHexString(flushBuffers.getValue(), 4) : "";
        LOG.logDebug(status, "getFlushBuffers:", result);
        if (status != 0) {
            throw new Exception("getFlushBuffers(" + deviceObj + "): " + status);
        }
        return result;
    }

    @Override
    public void setFlushBuffers(Device deviceObj, String value) throws Exception {
        Device2105.checkDeviceDetection();
        Pointer device = Device2105.openDevice((Device210x)deviceObj);
        long flushBuffers = Long.parseLong(value, 16);
        int status = CP210xManufacturing.DLL.CP210x_SetFlushBufferConfig(device, flushBuffers);
        Device2105.close(device);
        LOG.logDebug(status, "setFlushBuffers:", value);
        if (status != 0) {
            throw new Exception("setFlushBuffers(" + deviceObj + "): " + status);
        }
    }

    @Override
    public String getDeviceMode(Device deviceObj) throws Exception {
        Device2105.checkDeviceDetection();
        Pointer device = Device2105.openDevice((Device210x)deviceObj);
        ByteByReference deviceModeECI = new ByteByReference();
        ByteByReference deviceModeSCI = new ByteByReference();
        byte deviceMode = 0;
        int status = CP210xManufacturing.DLL.CP210x_GetDeviceMode(device, deviceModeECI, deviceModeSCI);
        Device2105.close(device);
        if (deviceModeECI.getValue() != 0) {
            deviceMode = (byte)(deviceMode | 1);
        }
        if (deviceModeSCI.getValue() != 0) {
            deviceMode = (byte)(deviceMode | 2);
        }
        String result = status == 0 ? Device2105.toHexString(deviceMode & 3, 1) : "";
        LOG.logDebug(status, "getDeviceMode:", result);
        if (status != 0) {
            throw new Exception("getDeviceMode(" + deviceObj + "): " + status);
        }
        return result;
    }

    @Override
    public void setDeviceMode(Device deviceObj, String value) throws Exception {
        Device2105.checkDeviceDetection();
        Pointer device = Device2105.openDevice((Device210x)deviceObj);
        ByteByReference deviceModeECI = new ByteByReference();
        ByteByReference deviceModeSCI = new ByteByReference();
        int status = CP210xManufacturing.DLL.CP210x_GetDeviceMode(device, deviceModeECI, deviceModeSCI);
        byte actualValue = Byte.parseByte(value, 16);
        byte actualECIValue = (byte)(actualValue & 1);
        byte actualSCIValue = (byte)(actualValue & 2);
        if (actualECIValue > 0) {
            actualECIValue = 1;
        }
        if (actualSCIValue > 0) {
            actualSCIValue = 1;
        }
        deviceModeECI.setValue(actualECIValue);
        deviceModeSCI.setValue(actualSCIValue);
        status = CP210xManufacturing.DLL.CP210x_SetDeviceMode(device, deviceModeECI.getValue(), deviceModeSCI.getValue());
        Device2105.close(device);
        LOG.logDebug(status, "setDeviceMode:", value);
        if (status != 0) {
            throw new Exception("setDeviceMode(" + deviceObj + "): " + status);
        }
    }

    @Override
    public String getLockValue(Device deviceObj) throws Exception {
        Device2105.checkDeviceDetection();
        Pointer device = Device2105.openDevice((Device210x)deviceObj);
        ByteByReference lockValue = new ByteByReference();
        int status = CP210xManufacturing.DLL.CP210x_GetLockValue(device, lockValue);
        Device2105.close(device);
        String result = status == 0 ? Device2105.toHexString(lockValue.getValue(), 2) : "";
        LOG.logDebug(status, "getLockByte:", result);
        if (status != 0) {
            throw new Exception("getLockByte(" + deviceObj + "): " + status);
        }
        return result;
    }

    @Override
    public void setLockValue(Device deviceObj, String value) throws Exception {
        Device2105.checkDeviceDetection();
        Pointer device = Device2105.openDevice((Device210x)deviceObj);
        int status = CP210xManufacturing.DLL.CP210x_SetLockValue(device);
        Device2105.close(device);
        LOG.logDebug(status, "setLockByte:", value);
        if (status != 0) {
            throw new Exception("setLockByte(" + deviceObj + "): " + status);
        }
    }

    @Override
    public final void resetSiliconLabsDefaultValues() {
        Property[] idProps = this.getIds();
        idProps[0].reset("10C4");
        idProps[1].reset("EA70");
        idProps[2].reset("32");
        idProps[3].reset("00");
        idProps[4].reset("0100");
        idProps[5].reset("0033");
        idProps[6].reset("CP2105 Dual USB to UART Bridge Controller");
        idProps[7].reset("Enhanced Com Port");
        idProps[8].reset("Standard Com Port");
        idProps[10].reset("3");
        idProps[11].reset("00");
        Property[] portConfigProps = this.getPortConfigs();
        CP2105GroupPortConfigRoot cp2105PortConfigRoot = (CP2105GroupPortConfigRoot)portConfigProps[0];
        cp2105PortConfigRoot.resetSiliconLabsDefaultValues();
    }
}

