/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.customizer.devices;

import com.silabs.customizer.devices.Device;
import com.silabs.customizer.devices.GroupBaudConfigRoot;
import com.silabs.customizer.devices.Property;
import java.util.Locale;

public class PropertyBaudConfig
extends Property {
    int baudConfigIndex;
    String highValue;
    String lowValue;
    long actualValue;
    long sysClk;
    long timerClk;
    int baudGen;
    int timer0Reload;
    short prescaler;
    long baudRate;

    public PropertyBaudConfig(Device device, GroupBaudConfigRoot parent, int index, long sysClk, long timerClk, String highValue, String lowValue) {
        super(device, parent, String.format("Baud Config %d", index), null);
        this.baudConfigIndex = index;
        this.highValue = highValue;
        this.lowValue = lowValue;
        this.sysClk = sysClk;
        this.timerClk = timerClk;
        this.initProperty();
    }

    @Override
    public void setDefaultValue(String value) {
        super.setDefaultValue(value.toUpperCase(Locale.ENGLISH));
    }

    @Override
    public void setValue(String value) {
        try {
            Long longValue = Long.parseLong(value, 10);
            super.setValue(String.format("%d", longValue));
            this.baudRate = longValue;
            this.updateBaudSettings();
        }
        catch (NumberFormatException numberFormatException) {}
    }

    @Override
    protected String readValueFromDevice() throws Exception {
        return ((GroupBaudConfigRoot)this.getParent()).getBaudConfig(this.baudConfigIndex);
    }

    public String getHighValue() {
        return this.highValue;
    }

    public String getLowValue() {
        return this.lowValue;
    }

    public String getActualValue() {
        return String.format("%d", this.actualValue);
    }

    private void updateBaudSettings() {
        this.baudGen = this.calculateBestBaudGen(this.sysClk, this.baudRate);
        this.prescaler = this.calculateBestPrescaler(this.sysClk, this.baudRate);
        this.actualValue = this.calculateBaudRate(this.sysClk, this.prescaler, this.baudGen);
        this.timer0Reload = this.calculateTimer0Reload(this.timerClk, this.actualValue);
    }

    private int calculateTimer0Reload(long timerClk, long actualBaudRate) {
        double timer0reload = 65536.0 - (double)timerClk * (18.0 / (double)actualBaudRate);
        return (int)Math.floor(timer0reload);
    }

    private long calculateBaudRate(long sysClk, int prescaler, int baudGen) {
        if (prescaler == 0) {
            return 0L;
        }
        double br = sysClk / (long)prescaler;
        return Math.round(br / (2.0 * (65536.0 - (double)baudGen)));
    }

    private short calculateBestPrescaler(long sysClk, long desiredBaudRate) {
        short[] prescale = new short[]{1, 4, 12, 48};
        int[][] baudgen = new int[4][2];
        long[][] tbr = new long[4][2];
        int i = 0;
        i = 0;
        while (i < 4) {
            baudgen[i][0] = this.calculateBaudGen(sysClk, prescale[i], desiredBaudRate);
            tbr[i][0] = this.calculateBaudRate(sysClk, prescale[i], baudgen[i][0]);
            baudgen[i][1] = tbr[i][0] >= desiredBaudRate ? baudgen[i][0] - 1 : baudgen[i][0] + 1;
            tbr[i][1] = this.calculateBaudRate(sysClk, prescale[i], baudgen[i][1]);
            ++i;
        }
        int indexi = 0;
        int space = Math.abs((int)(tbr[0][0] - desiredBaudRate));
        i = 0;
        while (i < 4) {
            int j = 0;
            while (j < 2) {
                if (space > Math.abs((int)(tbr[i][j] - desiredBaudRate))) {
                    indexi = i;
                    space = Math.abs((int)(tbr[i][j] - desiredBaudRate));
                }
                ++j;
            }
            ++i;
        }
        return prescale[indexi];
    }

    private int calculateBestBaudGen(long sysClk, long desiredBaudRate) {
        int[] prescale = new int[]{1, 4, 12, 48};
        int[][] baudgen = new int[4][2];
        long[][] tbr = new long[4][2];
        int i = 0;
        i = 0;
        while (i < 4) {
            baudgen[i][0] = this.calculateBaudGen(sysClk, prescale[i], desiredBaudRate);
            tbr[i][0] = this.calculateBaudRate(sysClk, prescale[i], baudgen[i][0]);
            baudgen[i][1] = tbr[i][0] >= desiredBaudRate ? baudgen[i][0] - 1 : baudgen[i][0] + 1;
            tbr[i][1] = this.calculateBaudRate(sysClk, prescale[i], baudgen[i][1]);
            ++i;
        }
        int indexi = 0;
        int indexj = 0;
        int space = Math.abs((int)(tbr[0][0] - desiredBaudRate));
        i = 0;
        while (i < 4) {
            int j = 0;
            while (j < 2) {
                if (space > Math.abs((int)(tbr[i][j] - desiredBaudRate))) {
                    indexi = i;
                    indexj = j;
                    space = Math.abs((int)(tbr[i][j] - desiredBaudRate));
                }
                ++j;
            }
            ++i;
        }
        return baudgen[indexi][indexj];
    }

    private int calculateBaudGen(long sysClk, int prescaler, long desiredBaudRate) {
        if (prescaler == 0) {
            return 0;
        }
        if (desiredBaudRate == 0L) {
            return 0;
        }
        double baudgen = 65536.0 - (double)sysClk / (double)prescaler / (double)(2L * desiredBaudRate);
        return (int)Math.round(baudgen);
    }

    public int getBaudGen() {
        return this.baudGen;
    }

    public short getPrescaler() {
        return this.prescaler;
    }

    public int getTimer0Reload() {
        return this.timer0Reload;
    }

    public long getBaudRate() {
        return this.baudRate;
    }
}

