/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.customizer.actions;

import com.silabs.customizer.UIConstants;
import com.silabs.customizer.devices.Device;
import com.silabs.customizer.devices.DeviceNone;
import com.silabs.customizer.devices.LoadVisitor;
import com.silabs.customizer.log.MessageLog;
import java.io.File;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;

public class LoadAction
extends Action
implements ISelectionChangedListener {
    private final List<Viewer> viewers = new LinkedList<Viewer>();
    private final Shell shell;
    private Device device;

    public LoadAction(Shell shell) {
        super("&Load Configuration");
        this.setId(LoadAction.class.getName());
        if (UIConstants.isWsCocoa()) {
            this.setAccelerator(0x40004F);
        } else {
            this.setAccelerator(262223);
        }
        this.setEnabled(false);
        this.shell = shell;
    }

    public void addViewer(Viewer viewer) {
        if (viewer != null) {
            this.viewers.add(viewer);
        }
    }

    public void removeViewer(Viewer viewer) {
        if (viewer != null) {
            this.viewers.remove(viewer);
        }
    }

    public void run() {
        FileDialog dialog = new FileDialog(this.shell, 4096);
        dialog.setText("Load Device Configuration");
        dialog.setFilterExtensions(new String[]{"*.txt"});
        String filename = dialog.open();
        if (filename != null) {
            this.handleLoad(filename);
            for (Viewer viewer : this.viewers) {
                viewer.refresh();
            }
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        ISelection selection = event.getSelection();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection sSelection = (IStructuredSelection)selection;
            Object first = sSelection.getFirstElement();
            this.device = first instanceof Device && !(first instanceof DeviceNone) ? (Device)first : null;
            this.setEnabled(this.device != null);
        }
    }

    private void handleLoad(String filename) {
        try {
            LoadVisitor.load(new File(filename), this.device);
            MessageLog.info("Load from: " + filename);
        }
        catch (Exception exc) {
            MessageLog.error(String.format("Load FAILED - %s - %s", exc.getMessage(), filename), exc);
        }
    }
}

